function plot_equilibria(chease_data1, chease_data2, varargin)
    if ~isempty(varargin)
      case1 = varargin{1};
      case2 = varargin{2};
    else
      case1 = ' case 1';
      case2 = ' case 2';
    end
    
    figure(1)
    
    ij_abv01 = chease_data1.eqdsk.psi>0;
    ij_abv02 = chease_data2.eqdsk.psi>0;
    psi1 = chease_data1.eqdsk.psi;
    psi2 = chease_data2.eqdsk.psi;
    psi1(ij_abv01) = 0;
    psi2(ij_abv02) = 0;
    
    subplot(3,2,[1 3 5])
    contour(chease_data1.eqdsk.rmesh,chease_data1.eqdsk.zmesh,psi1',10,'b');
    hold all
    plot(chease_data1.eqdsk.raxis, chease_data1.eqdsk.zaxis,'b+');
    hold all
    plot(chease_data1.eqdsk.rplas,chease_data1.eqdsk.zplas,'b','LineWidth',2);
    hold all
    contour(chease_data2.eqdsk.rmesh,chease_data2.eqdsk.zmesh,psi2',10,'r');
    hold all
    plot(chease_data2.eqdsk.raxis, chease_data2.eqdsk.zaxis,'r+');
    hold all
    plot(chease_data2.eqdsk.rplas,chease_data2.eqdsk.zplas,'r--','LineWidth',2);
    ylabel('Z [m]')
    xlabel('R [m]')
    title('psi contours')
    axis equal

    rho1 = chease_data1.profiledata.rho_tor_norm.data;
    rho2 = chease_data2.profiledata.rho_tor_norm.data;
    subplot(3,2,2)
    plot(chease_data1.eqdsk.rhotor_norm, chease_data1.eqdsk.p, 'b', ...
         chease_data1.eqdsk.rhotor_norm, chease_data2.eqdsk.p, 'r')
    ylabel('p [Pa]')
    legend({case1,case2})
    subplot(3,2,4)
    plot(chease_data1.eqdsk.rhotor_norm, chease_data1.eqdsk.q, 'b', ...
         chease_data1.eqdsk.rhotor_norm, chease_data2.eqdsk.q, 'r')
    ylabel('q')
    B0 = chease_data1.eqdsk.b0; R0 = chease_data1.eqdsk.r0; mu0 = 4e-7*pi;
    chease2si_jpar = (B0/(mu0*R0));
    subplot(3,2,6)
    plot(rho1, chease_data1.profiledata.j_par_eq_av_j_dot_b_av_over_b0.data*chease2si_jpar, 'b', ...
         rho2, chease_data2.profiledata.j_par_eq_av_j_dot_b_av_over_b0.data*chease2si_jpar, 'r')
    xlabel('rho')
    ylabel('jpar [MA/m\^2]')
    
    
    set(gcf,'paperpositionmode','auto')

    set(gcf,'position',[100 100 1150 (2/3)*1150])
    
end
