% run this script to get _chease_data_ with fields _eqdsk_ and
% _profiledata_
% before: run chease from CHEASEgui and get variables into workspace

% find expeq file
for ii=1:length(cheasegui_fname_out);
    if ~isempty(strfind(cheasegui_fname_out{ii},'EXPEQ.OUT_'))
        expeqfile = cheasegui_fname_out{ii}; break
    end
end
% find cols file
for ii=1:length(cheasegui_fname_out);
    if ~isempty(strfind(cheasegui_fname_out{ii},'.cols'))
        ocolsfile = cheasegui_fname_out{ii}; break
    end
end
% find eqdsk file
for ii=1:length(cheasegui_fname_out);
    if ~isempty(strfind(cheasegui_fname_out{ii},'EQDSK'))
        eqdskfile = cheasegui_fname_out{ii}; break
    end
end


plot_expeq(expeqfile,'r.-');

% read ocols profile data
profiledata = read_ocols(ocolsfile);

% also read eqdsk data
cocos = 2; % usual value for chease output
eqdskdata = read_eqdsk(eqdskfile,cocos);

% store both in structure as required by RAPTOR
clear chease_data
chease_data.eqdsk = eqdskdata;
chease_data.profiledata = profiledata; 

% CHOOSE A NAME FOR THE MAT FILE
save TCV_noncirc.mat chease_data
 
