% This script extracts all data at the flat top of a shot
% e.g. shot_data_flat_top('46716_0_3_SS2B_ohmic_shot',90)

function shot_data_flat_top(astrafile,t_flattop)
clc;  
close all;
% To Do:
% 1. (t, x0, v0 and U must be specified afterwards and added to this file to reproduce optimization results)

%% Settings used for the TCV data files
%%% Ohmic shot
% astrafile = '46716_0_3_SS2B_ohmic_shot';
% t_flattop = 90;

%%% ECH constant shot
% astrafile = '46716_all_NSS2G_ECH_constant';
% t_flattop = 9;

%%% ECH time varying shot
% astrafile = '46714_all_NSS2G_ECH_varying';
% t_flattop = 1650;

%%% ECCD shot 46712
% astrafile = '46712_all_NSS2G_ECCD';
% t_flattop = 600;

%%% ECCD shot 46715
% astrafile = '46715_all_NSS2G_ECCD';
% t_flattop = 600;

%% Settings used for the ASDEX data files
%%% Ohmic shot
% astrafile = '26328_03_13ASSpBND21_RES';
% t_flattop = 310;

%%% ECH shot 26802
% astrafile = '26802_03_13ASSpBND21_RES';
% t_flattop = 310;

%% Save .mat structure for all the variables at time index of flat top
ASTRA_data = load(astrafile); % contains ASTRA data for equilibrium
% For TCV data:
% ASTRA_data = ASTRA_data.astra_out;

% plot(1:length(ASTRA_data.ipl),ASTRA_data.ipl)
% xlabel('timepoint')
% ylabel('I_{pl}')

% % Conversion of Units: ASTRA: MA, keV and 10^19 1/m^3 <-> RAPTOR A, eV  and 1/m^3
% ASTRA_data.ne = ASTRA_data.ne*1e19;
% ASTRA_data.ni = ASTRA_data.ni*1e19;
% ASTRA_data.te = ASTRA_data.te*1e3; % [eV]
% ASTRA_data.ti = ASTRA_data.ti*1e3; % [eV]
% ASTRA_data.iohm = ASTRA_data.iohm*1e6; % [A]
% ASTRA_data.ipl = ASTRA_data.ipl*1e6; % [A]

%%% Select data specific to TCV tokamak at flattop
%%% epsilon, kappa en delta follow from definitions used in ASTRA (see online
%%% manual: http://www.ipp.mpg.de/~git/astra/section.php?sec=49)
ASTRA_data_flattop.btor = ASTRA_data.btor(t_flattop); % Toroidal field [T]
ASTRA_data_flattop.rtor = ASTRA_data.rtor(t_flattop); % Major radius [m]
ASTRA_data_flattop.epsilon = (ASTRA_data.sqeps(:,t_flattop)).^2; % [-]inverse aspect ratio a/R
ASTRA_data_flattop.kappa = mean(ASTRA_data.elon(:,t_flattop)); % [-] elongation: default scenario kappa, 
ASTRA_data_flattop.delta = mean(ASTRA_data.tria(:,t_flattop)); % [-] triangularity: default scenario delta
ASTRA_data_flattop.rhotor = ASTRA_data.rhotor(:,t_flattop); % normalized toroidal flux coordinate
ASTRA_data_flattop.PHI = ASTRA_data.PHI(end,t_flattop);
ASTRA_data_flattop.ipol = ASTRA_data.ipol(:,t_flattop);
ASTRA_data_flattop.vr = ASTRA_data.vr(:,t_flattop);
ASTRA_data_flattop.g11 = ASTRA_data.g11(:,t_flattop);
ASTRA_data_flattop.g22 = ASTRA_data.g22(:,t_flattop);
ASTRA_data_flattop.g33 = ASTRA_data.g33(:,t_flattop);
ASTRA_data_flattop.q = ASTRA_data.q(:,t_flattop);
ASTRA_data_flattop.ft = ASTRA_data.ft(:,t_flattop);
ASTRA_data_flattop.PSI = ASTRA_data.PSI(:,t_flattop);
ASTRA_data_flattop.itot = ASTRA_data.itot(:,t_flattop); % Data structure used for the checks in ASTRA_to_RAPTOR
ASTRA_data_flattop.volum = ASTRA_data.volum(:,t_flattop); % Data structure used for the checks in ASTRA_to_RAPTOR

% ASTRA_data_flattop.zeffr = ASTRA_data.zeffr;
% ASTRA_data_flattop.tgrid_ASTRA = ASTRA_data.t;
% ASTRA_data_flattop.ipl = ASTRA_data.ipl;

filename = [astrafile '_flat_top'];
save(filename,'ASTRA_data_flattop');
return