%% RAPTOR RFX example
close all hidden;
clear all;

run(fullfile(fileparts(mfilename('fullpath')),'..','..','RAPTOR_path.m')); % add RAPTOR path
%%
[config] = RAPTOR_config('RFX'); % load default params

config.debug.iterplot = 0;
config.debug.iterdisp = 100;
config.debug.verbosity = -1; % allow custom

Ts1 = 0.0001;
Ts2 = 0.0002;
%time grid
t_0 = 0.0;
t_end = 0.2;

tgrid_startup = [t_0:Ts1:t_0+10*Ts1]; % startup covergence
tgrid_standard = [t_0+11*Ts1:Ts2:t_end];

tt = sort([tgrid_standard,...
                                 tgrid_startup]);

config.saw = saw('porcelli');
config.saw.params.s1crit = 0.36;
config.saw.params.active = true;
                             
config.grid.tgrid  = tt([true,diff(tt)>1e-6]);    

% generate for these params model structure, params, init, geometry g, kinetic profiles v.
[model,params,init,g,v,U] = build_RAPTOR_model(config);
params.chi_e.cano = 9;
params.chi_e.deltacentral = 0.25;

% Define the initial condition
x0 = RAPTOR_initial_conditions(model,init,g(:,1),v(:,1)); 

simres = RAPTOR_predictive(x0,g,v,U,model,params);

out = RAPTOR_out(simres,model,params);

RAPTOR_plot_GUI(out);