%% Tutorial on formal tests for RAPTOR
% A suite of tests for RAPTOR is provided to ensure that no modifications
% are committed that accidentally break the code.
%
% The rules:
% * Basic tests are automatically run on each push for all branches
% * More extensive tests are run automatically at night, including running all the tutorials.
% * Merges to the master branch must pass all the tests.
%
% All the tests are stored in the folder |./tests| and defined as classes.
% See |RAPTOR_matlab_basic_tests| for an example, and the documentation
% |help matlab.unittest.TestCase|

%% A generic test running function is available
%%
% |addpath('tests')|
% |run_RAPTOR_tests('basic')|
% other options exist for Simulink tests and code generation tests.
% They may not all work depending on your set up.

%% What to do if a test fails
% If a test fails, the specific test can be re-run (to inspect the error thrown)
% by calling the test from the /tests directory and specifying the test
% name. E.g. suppose test RAPTOR_matlab_basic_tests/testTCVdefault failed.
% Then re-run it using
% |run(RAPTOR_matlab_basic_tests,'testTCVdefault')|
