%% Tutorial running RAPTOR using IMAS IDS inputs
disp('This tutorial requires an IMAS installation')
return
%%

close all hidden;
%% INPUT/OUTPUT CONFIGURATION
% IMAS shot and run number
shot                = 55592; % shot number
run_in              = 20; % run number
input_user_or_path  = 'mmarin'; % owner of the database
input_database      = 'tcv'; % name of the machine
% % run_out             = 20; % run number of new entry
% % output_user_or_path = getenv('USER');
% % output_database     = input_database;

%% OPEN INPUT DATAFILE TO GET DATA FROM IMAS SCENARIO DATABASE

disp('=> Open input datafile') 
% opening an existing Data entry
% idx_in  = imas_open_env('ids',shot,run_in,input_user_or_path,input_database,'3');
idx_in  = imas_open_env_backend(shot, run_in, input_user_or_path, input_database, '3', 13);

%% READ INPUT IDSS FROM LOCAL DATABASE
% to load ftom input IDS over whole time window 

disp('=> Read input IDSs')
% reading the content of an IDS variable from a Data Entry
fullshot_summary  = ids_get(idx_in,'summary');
core_profiles = ids_get(idx_in,'core_profiles');

%%


[config] = RAPTOR_config('TCV');

config.grid.tgrid = fullshot_summary.time; 

config.ti.method = 'direct';
config.ne.method = 'direct';

config.ze.method = 'direct';
config.ni.method = 'qnze';
config.n1.method = 'qnze';


% ohmic shot, for more advanced settings, see ITER IMAS demo 
config.echcd = RAPTORmodule('none');
config.ichcd = RAPTORmodule('none');
config.nbhcd = RAPTORmodule('none');
config.lhhcd = RAPTORmodule('none');


config.chi_e = RAPTORmodule('chi_FF');


config.atom.Z1 = 6; config.atom.A1 = 12; % carbon


%%
[model,params,init,g,v,u] = build_RAPTOR_model(config);

u(1, :) = abs(fullshot_summary.global_quantities.ip.value);

ne_input = interp1(core_profiles.profiles_1d{1}.grid.rho_tor_norm, core_profiles.profiles_1d{1}.electrons.density,model.rgrid.rhogauss);
v(model.ne.vind) = model.ne.Lamgauss\ne_input;

ti_input = interp1(core_profiles.profiles_1d{1}.grid.rho_tor_norm, core_profiles.profiles_1d{1}.ion{1}.temperature,model.rgrid.rhogauss);
v(model.ti.vind) = model.ti.Lamgauss\ti_input;

ze_input = interp1(core_profiles.profiles_1d{1}.grid.rho_tor_norm, core_profiles.profiles_1d{1}.zeff,model.rgrid.rhogauss);
v(model.ze.vind) = model.ze.Lamgauss\ze_input;

params.chi_e.te_constant = 1.2;
params.chi_e.cano = 1;

% set x0 from IDS
init.te0 = 500;
x0 = RAPTOR_initial_conditions(model,init,g(:,1),v(:,1)); 


%%

% Solve for stationary state
param_z = 'Upl'; % plasma loop voltage unknown
% 1: 'Upl'
% 2: 'Ip'
% 3: 'Pe'
  
verbosity = 3;

order_of_mag.Upl = 0.1; % initial condition should be provided for unknown loop voltage
[simres, ~, ~, outs] = stationary_state_solver(model, params, init, g, v, u, ...
    param_z, order_of_mag, verbosity, x0);
  
  
%%

figure;
subplot(131)
plot(core_profiles.profiles_1d{1}.grid.rho_tor_norm, core_profiles.profiles_1d{1}.q, ...
     outs.rho, outs.q)
legend('IDS','RAPTOR')
xlabel('rho')
title('q')
subplot(132)
plot(core_profiles.profiles_1d{1}.grid.rho_tor_norm, core_profiles.profiles_1d{1}.electrons.temperature, ...
     outs.rho, outs.te)
xlabel('rho')   
title('T_e [eV]')
subplot(133)
plot(core_profiles.profiles_1d{1}.grid.rho_tor_norm, core_profiles.profiles_1d{1}.ion{1}.temperature, ...
     outs.rho, outs.ti)   
xlabel('rho')
title('T_i [eV]')
