%% GUI tutorial - how to set up a custom GUI for outputs that interest you

%% Independent GUI use and out definition from scratch (for general use)
close all hidden;
clear out;
run(fullfile(pwd,'..','RAPTOR_path.m')); % add RAPTOR path
out.rho = linspace(0,1,21)';
out.time = [0:0.01:1];
out.a = (out.rho.^2)*sin(2*pi*10*out.time); % fake data

pp = RAPTOR_plot_GUI; % get defaults

% plot definitions
plots{1} = struct('xdata','out.time','xlabel','t',...
            'ydata','out.a(end,:)' ,'ylabel','a(end) time trace','yscale',1,'axesnr',1,'sty','--');
     
plots{2} = struct('xdata','out.rho','xlabel','\rho',...
            'ydata','out.a(:,%i)' ,'ylabel','a profile','yscale',1,'axesnr',2,'sty','-','ylim',[-1 1]);
        
% axis positions
axesdef(1).position = [0.1 0.1 0.8 0.4];
axesdef(2).position = [0.1 0.5 0.8 0.4];

pp.axes = axesdef;
pp.plots = plots;
RAPTOR_plot_GUI(out,pp)

%% RAPTOR-related use
% standard calls for simple RAPTOR run
[config] = RAPTOR_config; % load default params
% generate model, params, init, geometry g, kinetic profiles v
[model,params,init,g,v,U] = build_RAPTOR_model(config);
U(1,:) = 80e3*ones(size(params.tgrid));
% input Ip trace: constant 80kA
init.Ip0 = U(1,1);
% Define the initial condition
x0 = RAPTOR_initial_conditions(model,init,g(:,1),v(:,1));
simres = RAPTOR_predictive(x0,g,v,U,model,params);
%%
% generate out structure
out = RAPTOR_out(simres,model,params);

% uses of the GUI:
%% simple plots
RAPTOR_plot_GUI(out,'simple');

%% overview plot
RAPTOR_plot_GUI(out,'overview');

%% customize plot
pp = RAPTOR_plot_GUI('simple'); % get config structure for simple
disp(pp); % inspect
% customize
disp(pp.plots{1});
p = pp.plots; % copy existing trace definitions

% add li vs time trace to first axis (axesnr,1)
        p = [p, struct('xdata','out.time','xlabel','t',...
            'ydata','out.li3(end,:)' ,'ylabel','li3','yscale',1,'axesnr',1,'sty','--')];
     
% add profile trace on sixth axis
p = [p,struct('xdata','out.rho','xlabel','\rho',...
            'ydata','out.shear(:,%i)' ,'ylabel','shear','yscale',1,'axesnr',6,'sty','-')];
% '%i' signals that this profile changes in time
% it is evaluated at time index it as: eval(sprintf('out.shear(:,%i)',it)) 
      
% append to existing pp sturcture
pp.plots = p;
% call GUI
RAPTOR_plot_GUI(out,pp); % get config structure for simple


