function [gkii, eqdata] = update_equilibrium(model, params, xkiim1, gkiim1, vk,  subii, it)
% evaluate the equilibrium
persistent rst LYkii

switch model.equi.source
  case 'liuqe'
    %%% [TODO: put this in a separate function update_equilibrium_LIUQE?] %%%
    if (subii==1 && it <= params.equi.it_stdliu) % first iteration: standard LIUQE with reset
      rst = 1; % initialize rst flag
      prescribe_bf = false; % use standard basis functions
      spline_bf = false;
    elseif params.equi.use_stdliu
      rst = 0;
      prescribe_bf = false; % use standard basis functions
      spline_bf = params.equi.bfuncspl;
      if spline_bf
        [pprime, ttprime, rhopsiN, p, q, jtor, Ip] = eval_pp_ttp_on_uniform_rhopsi(xkiim1, gkiim1, vk, model); % extra RAPTOR profiles for illustration
      end
    elseif isempty(rst)
      rst = 0;
      [pprime, ttprime, rhopsiN, p, q, jtor, Ip] = eval_pp_ttp_on_uniform_rhopsi(xkiim1, gkiim1, vk, model);
      prescribe_bf = true; % use modified basis functions
    else % rst set to 1 when LIUQE crashed
      [pprime, ttprime, rhopsiN, p, q, jtor, Ip] = eval_pp_ttp_on_uniform_rhopsi(xkiim1, gkiim1, vk, model);
      prescribe_bf = true; % use modified basis functions
    end
    
    if params.equi.cstequi && it>1 % maintain equil of it = 1
      stdliu = 1;
      L = params.equi.L_init;
      LXk = meqxk(params.equi.LX, 1);
      LYtmp = LYkii; 
    else  % solve equilibrium
      if prescribe_bf % prescribed basis functions from RAPTOR profiles
        stdliu = 0;
        L = params.equi.L;
        LXk = meqxk(params.equi.LX,it);
        LYtmp = liut_bf(L, LXk, LYkii, pprime, ttprime, params.equi.bfuncttp);
        if params.debug.verbosity >= 3
          plot_RAPTOR_LY_prfcpl(L, LYtmp, rhopsiN, pprime, ttprime, p, q, jtor, Ip);
          pause()
        end
      else % basis functions standard or splines
        stdliu = 1;
        LXk = meqxk(params.equi.LX,it);
        if it==1
          L = params.equi.L_init; 
        else
          L = params.equi.L;
          if spline_bf
            ng = numel(L.P.wag); 
            psiN_spldef = params.equi.splpsi';
            Pp = interp1(rhopsiN.^2, pprime, psiN_spldef);
            TTp = interp1(rhopsiN.^2, ttprime, psiN_spldef);
            LXk.ag = zeros(ng,1);
            LXk.ag(1:ng/2) = 2*pi*L.dsx*Pp;
            mu0 = 4e-7*pi;
            LXk.ag(ng/2+1:end) = 2*pi*L.dsx/mu0*TTp;
          end
        end
        
        if rst
          extrargs = {'rst', rst};
        else
          IyD = LYkii.Iy;
          Ie  = [LXk.Ia; LXk.Iu];
          % The following ones are just default values
          dz  = zeros(L.ndz,1);
          aq  = [];
          aW  = [];
          z0  = 0;
          Fnp = [];
          extrargs = {'rst', rst, 'IyD', IyD, 'Ie', Ie, 'dz', dz, 'aq', aq, 'aW', aW, 'z0', z0, 'Fnp', Fnp};
        end
     
        LYtmp = liut(L, LXk, extrargs{:}); 
        if params.debug.verbosity >= 3
          meqplotliu(L,LXk,LYtmp)
          if spline_bf && it>1
            plot_RAPTOR_LY_prfcpl(L, LYtmp, rhopsiN, pprime, ttprime, p, q, jtor, Ip, params.equi.splpsi, LXk.ag);
            pause()
          elseif it>1 
            [pprime, ttprime, rhopsiN, p, q, jtor, Ip] = eval_pp_ttp_on_uniform_rhopsi(xkiim1, gkiim1, vk, model);
            plot_RAPTOR_LY_prfcpl(L, LYtmp, rhopsiN, pprime, ttprime, p, q, jtor, Ip);
            pause()
          end
        end
      end
    end
    
    % Validate results
    if ~isempty(LYtmp) % Results available: update
      % Eval norms for convergence
      if subii == 1
        eq_state_inc_norm = NaN;
        eq_out_inc_norm = NaN;
      else
        [eq_state_inc_norm,eq_out_inc_norm] = eval_LIUQE_inc_norm(LYtmp, LYkii);
        
      end
      LYkii = LYtmp;
      rst = 0;
    else %if results not available, keep previous LYii and reset LIUQE at next subiteration
      err_str = sprintf('LIUQE failed at subiteration %d and time index %d \n', subii, it);
      fprintf(err_str);
      rst = 1;
      % Reset norms for convergence
      eq_state_inc_norm = NaN;
      eq_out_inc_norm = NaN;
    end
    
    % Store number of iterations and exit flags
    if ~rst
      eq_info.N_Picard = LYkii.kit;
    end
    eq_info.std_LIU = stdliu;
    eq_info.eq_state_inc_norm = eq_state_inc_norm;
    eq_info.eq_out_inc_norm = eq_out_inc_norm;
    
    
    %  --------------    OUTPUTS ------------------------
    [gkii,rhotornorm] = LY2RAPTOR(L.pQ.^2',LYkii,model.geom,gkiim1,params.equi.flag_calcPhi,model.realtime);
    
    if params.debug.verbosity >= 3
      plot_RAPTORgeom_LY(gkii, LYkii, rhotornorm, model)
    end
    
    eqdata.data_out = LYkii;
    eqdata.data_in = LXk;
    eqdata.eq_info = eq_info;
    
    
    %------------- The other functions have to be fixed still ----------
    
    
    
  case 'liuqe_std'
    error('broken at the moment, need to fix the norms for convergence')
    
    
    
  case 'chease'
    error('broken at the moment')
    gk_new = update_g_from_CHEASE(xkm1,gk,vk,xdot,u,stapk,geopk,trapk,it,dt,model,params);
    % update G for the rest of the foreseeable future
    G(:,it:end) = repmat(gk_new,1,size(G,2)-it+1); %use this
  case 'mock'
    % test case to test interfaces without using equilibrium code.
    [gkii, eqdata] = update_equilibrium_mock(gkiim1);
    eqdata.eq_info.eq_state_inc_norm = NaN;
    eqdata.eq_info.eq_out_inc_norm = NaN;
end

end


function [gkii, eqdata] = update_equilibrium_mock(gkiim1)
% mock version for testing
gkii = gkiim1; % just keep the same gk
eqdata = struct();
end


%%% TO BE MOVED TO SOME update_LIUQE_equilibrium.m
function [norm_state,norm_out] = eval_LIUQE_inc_norm(LYii, LYiim1)

% norm on psi(R,Z) increment
norm_state = norm(LYii.Fx-LYiim1.Fx)/norm(LYii.Fx);


Q0Qnew = LYii.Q0Q;
Q1Qnew = LYii.Q1Q;
Q2Qnew = LYii.Q2Q;
Q3Qnew = LYii.Q3Q;
Q4Qnew = LYii.Q4Q;
TQnew = LYii.TQ;
iqQnew = LYii.iqQ;
psiAnew = LYii.FA;
psiBnew = LYii.FB;

Q0Qold = LYiim1.Q0Q;
Q1Qold = LYiim1.Q1Q;
Q2Qold = LYiim1.Q2Q;
Q3Qold = LYiim1.Q3Q;
Q4Qold = LYiim1.Q4Q;
TQold = LYiim1.TQ;
iqQold = LYiim1.iqQ;
psiAold = LYiim1.FA;
psiBold = LYiim1.FB;

% weights for convergence
wQ0Q = 1/9;
wQ1Q = 1/9;
wQ2Q = 1/9;
wQ3Q = 1/9;
wQ4Q = 1/9;
wTQ = 1/9;
wiqQ = 1/9;
wpsiA = 1/9;
wpsiB = 1/9;

% Masking point if not used in the fitting 
mask = true(size(Q0Qnew));
mask(end) = false;


% output norm
norm_out = wQ0Q*norm(Q0Qnew(mask) - Q0Qold(mask))/norm(Q0Qold(mask))     + wQ1Q*norm(Q1Qnew(mask) - Q1Qold(mask))/norm(Q1Qold(mask))     +...
           wQ2Q*norm(Q2Qnew(mask) - Q2Qold(mask))/norm(Q2Qold(mask))     + wQ3Q*norm(Q3Qnew(mask) - Q3Qold(mask))/norm(Q3Qold(mask))     +...
           wQ4Q*norm(Q4Qnew(mask)-Q4Qold(mask))/norm(Q4Qold(mask))       + wTQ*norm(TQnew(mask)- TQold(mask))/norm(TQold(mask))          +...
           wiqQ*norm(iqQnew(mask) - iqQold(mask))/norm(iqQold(mask))     + wpsiA*norm(psiAnew - psiAold)/norm(psiAold) +...
           wpsiB*norm(psiBnew - psiBold)/norm(psiBold);

end