function stap = state_profiles(x,xdot,g,gdot,v,vdot,model,stap)

%kinetic stuff
[stap.ne,stap.dne_dx] = eval_ne(x,g,v,model,true);
[stap.ni,stap.dni_dx] = eval_ni(x,g,v,model,true);
[stap.n1,stap.dn1_dx] = eval_nx(1,x,g,v,model,true,false);
[stap.n2,stap.dn2_dx] = eval_nx(2,x,g,v,model,true,false);
[stap.n3,stap.dn3_dx] = eval_nx(3,x,g,v,model,true,false);
[stap.ze,stap.dze_dx] = eval_ze(x,g,v,model,true,false);

[stap.nedot,stap.dnedot_dxdot] = eval_ne(xdot,g,vdot,model,true);
[stap.tedot,stap.dtedot_dxdot] = eval_te(xdot,g,vdot,model,true);

switch model.ni.method
  case 'nescal'
    [stap.nidot,stap.dnidot_dxdot] = eval_ni(xdot,g,v,model,true);
  otherwise
    [stap.nidot,stap.dnidot_dxdot] = eval_ni(xdot,g,vdot,model,true);
end

switch model.ti.method
  case 'tescal'
    [stap.nidot,stap.dnidot_dxdot] = eval_ti(xdot,g,v,model,true);
  otherwise
    [stap.nidot,stap.dnidot_dxdot] = eval_ti(xdot,g,vdot,model,true);
end

[stap.tidot,stap.dtidot_dxdot] = eval_ti(xdot,g,vdot,model,true);

[stap.te,stap.dte_dx] = eval_te(x,g,v,model,true);
[stap.ti,stap.dti_dx] = eval_ti(x,g,v,model,true);

[stap.tep,stap.dtep_dx] = eval_tep(x,g,v,model,true);
[stap.tip,stap.dtip_dx] = eval_tip(x,g,v,model,true);

[stap.nep,stap.dnep_dx] = eval_nep(x,g,v,model,true);
[stap.nip,stap.dnip_dx] = eval_nip(x,g,v,model,true);

[stap.vt,stap.dvt_dx]   = eval_y(x,v,model.vt,model.rgrid,true);
[stap.vtp,stap.dvtp_dx] = eval_yp(x,v,model.vt,model.rgrid,true);

%% Magnetic profiles
[stap.q,stap.dq_dx]         = eval_q(x,g,v,model,true);
[stap.iota,stap.diota_dx]   = eval_iota(x,g,v,model,true);
[stap.shear,stap.dshear_dx] = eval_shear(x,g,v,model,true);
[stap.psi,stap.dpsi_dx]     = eval_psi(x,g,v,model,true);
[stap.psip,stap.dpsip_dx]   = eval_psip(x,g,v,model,true);
[stap.psipp,stap.dpsipp_dx] = eval_psipp(x,g,v,model,true);
[stap.upl, stap.dupl_dx, stap.dupl_dxdot] = eval_upl(x,xdot,g,gdot,v,model,true);

%% H mode
stap.lamH = v(model.hmode.vind.activation); % used for various Hmode options

switch model.hmode.modeltype
  case 'imposed'
    % no information to be passed (except stap.lamH)
  case 'gradient'
    stap.gteped = v(model.hmode.vind.gteped);
    stap.gtiped = v(model.hmode.vind.gtiped);
    stap.gneped = v(model.hmode.vind.gneped);
    stap.rhoped = v(model.hmode.vind.rhoped);
  case {'none','MS'}
    % ok do nothing
  otherwise
    error('not supported yet')
end

%% Ip
[Ipl,dIpl_dx] = eval_Ipl(x,g,[],model,false);
stap.Ip = Ipl(end); 
stap.dIp_dx = dIpl_dx(end,:);

%% NTMs
if strcmp(model.ntm.method,'state')
    stap.wntms = x(model.ntm.xind);
else
    stap.wntms = v(model.ntm.vind);
end

if strcmp(model.ntm.method,'state')
    stap.wdotntms = xdot(model.ntm.xind);
else
    stap.wdotntms = vdot(model.ntm.vind);
end

end