function stap = init_stap(model)

ngauss = model.rgrid.nrhogauss;
nx = model.dims.nx;

gg      = zeros(ngauss,1);
dgg_dx  = zeros(ngauss,nx);

%%
%kinetic stuff
stap = struct(...
'psi',gg,...
'dpsi_dx',dgg_dx,...
'psip',gg,...
'dpsip_dx',dgg_dx,...
'psipp',gg,...
'dpsipp_dx',dgg_dx,...
'upl',gg,...
'dupl_dxdot',dgg_dx,...
'dupl_dx',dgg_dx,...
'ne',gg,...
'dne_dx',dgg_dx,...
'nedot',gg,...
'dnedot_dxdot',dgg_dx,...
'ni',gg,...
'dni_dx',dgg_dx,...
'nidot',gg,...
'dnidot_dxdot',dgg_dx,...
'nep',gg,...
'dnep_dx',dgg_dx,...
'nip',gg,...
'dnip_dx',dgg_dx,...
'n1',gg,...
'dn1_dx',dgg_dx,...
'n2',gg,...
'dn2_dx',dgg_dx,...
'n3',gg,...
'dn3_dx',dgg_dx,...
'te',gg,...
'dte_dx',dgg_dx,...
'ti',gg,...
'dti_dx',dgg_dx,...
'ze',gg,...
'dze_dx',dgg_dx,...
'tep',gg,...
'dtep_dx',dgg_dx,...
'tip',gg,...
'dtip_dx',dgg_dx,...
'tedot',gg,...
'dtedot_dxdot',dgg_dx,...
'tidot',gg,...
'dtidot_dxdot',dgg_dx,...
'vt',gg,...
'dvt_dx',dgg_dx,...
'vtp',gg,...
'dvtp_dx',dgg_dx,...
'p',gg,...
'q',gg,...
'dq_dx',dgg_dx,...
'iota',gg,...
'diota_dx',dgg_dx,...
'shear',gg,...
'dshear_dx',dgg_dx,...
'Ip',0,...
'dIp_dx',zeros(1,nx),...
'lamH',0, ...
'gtiped',0,...
'gteped',0,...
'gneped',0,...
'rhoped',0,...
'wntms',zeros(model.ntm.n_ntm,1),...
'wdotntms',zeros(model.ntm.n_ntm,1)...
);

return