function geop = geometry_profiles(g,gdot,model,geop)

%% geometry
geop.Fb      = model.geom.LamG(end,:)*g(model.geom.ind_F);
geop.F       = eval_F([],g,[],model,true);
geop.Fp      = eval_Fp([],g,[],model,true);
geop.g0      = eval_g0([],g,[],model,true);
geop.g0p     = eval_g0p([],g,[],model,true);
geop.g1      = eval_g1([],g,[],model,true);
geop.g2      = eval_g2([],g,[],model,true);
geop.g23or   = eval_g23or([],g,[],model,true);
geop.g23orp   = eval_g23orp([],g,[],model,true);

geop.Phib    = eval_Phib([],g,[],model,true);
geop.Phibdot = eval_Phib([],gdot,[],model,true);

geop.Vp      = eval_Vp([],g,[],model,true);
geop.Vpp     = eval_Vpp([],g,[],model,true);
geop.dVpdt    = eval_Vp([],gdot,[],model,true);

geop.kappa = eval_kappa([],g,[],model,true);
geop.epsilon = eval_epsilon([],g,[],model,true);
geop.epsilonp = eval_epsilonp([],g,[],model,true);
geop.Rgeom = eval_Rgeom([],g,[],model,true);
geop.Rgeomp = eval_Rgeomp([],g,[],model,true);
geop.delta = eval_delta([],g,[],model,true);

geop.B0 = geop.F(end)./model.equi.R0; % B0 = F_LCFS/R0 with F = RBphi 

return

