function plot_shaded_deviation(x, meanprof, stdprof, color, facealpha, varargin)
if isempty(varargin)
  curvetop = meanprof + stdprof;
  curvebott = meanprof - stdprof;  
elseif strcmp(varargin{1},'direct')
  curvetop = max(meanprof, stdprof);
  curvebott = min(meanprof, stdprof);
else
  error('not a valid option')
end
if size(x,2) == 1
  x=x'; meanprof=meanprof'; stdprof=stdprof';
end  
xfill = [x, fliplr(x)];
yfill = [curvetop, fliplr(curvebott)];
fill(xfill, yfill, color,'FaceAlpha', facealpha, 'HandleVisibility', 'off');
% plot(x, meanprof, color, 'LineWidth', 2, 'DisplayName', legend);
end
