function positions = axespos(nrows,ncols,rowmarg,colmarg,spaces)

rowleft = rowmarg(1);
rowright = rowmarg(2);
coltop = colmarg(1);
colbot = colmarg(2);
srows = spaces(1);
scols = spaces(2);

drows = ((1-rowleft-rowright) - srows*(nrows-1))/nrows;
dcols = ((1-coltop-colbot) - scols*(ncols-1))/ncols;

for irow = 1:nrows
    for icol = 1:ncols
        prow = rowleft+(drows+srows)*(irow-1);
        pcol = 1-coltop-icol*dcols - scols*(icol-1);
        positions(irow,icol).position = [prow,pcol,drows,dcols];
    end
end
end