function RAPTOR_plot_xgv(x,g,v,model)
%%
psi = eval_psi(x,g,v,model,false);
iota = eval_iota(x,g,v,model,false);
te = eval_te(x,g,v,model,false);
ti = eval_ti(x,g,v,model,false);
ne = eval_ne(x,g,v,model,false);
ni = eval_ni(x,g,v,model,false);
ze = eval_ze(x,g,v,model,false,false);
Ipl = eval_Ipl(x,g,v,model,false);

g1 = eval_g1(x,g,v,model,false);
g2 = eval_g2(x,g,v,model,false);
g3 = eval_g3(x,g,v,model,false);
Vp = eval_Vp(x,g,v,model,false);
F = eval_F(x,g,v,model,false);
H = eval_H(x,g,v,model,false);

rho = model.rgrid.rho;

%% normalize for visualization
V   = trapz(rho,Vp); % approx
Ip  = Ipl(end);
mu0 = 4e-7*pi;
R0  = model.equi.R0;

fprintf('Ip=%2.2eA, Vol=%2.2em3, Rax=%2.2fm \n',Ip,V,sqrt(1./g3(1)))

g1N = g1/Ip.^2/mu0;
g2N = g2/Ip.^2/mu0*R0^2;
g3N = g3.*R0.^2;
VpN = Vp/V;

% FN = F/(B0*R0); %% is it still relevant to normalize here? 

HN = H./(mu0*Ip/V);

%% plot
subplot(331);
plot(rho,psi,'-')
title('\psi')
xlabel('rho')

subplot(332);
plot(rho,iota,'-')
title('iota')
xlabel('rho')

subplot(333);
plot(rho,te,'-',rho,ti,'--')
title('T_e,T_i')
xlabel('rho')

subplot(334);
plot(rho,ne,'-',rho,ni,'--')
title('n_e,n_i')
xlabel('rho')

subplot(335);
plot(rho,iota,'-',rho,ze,'--')
title('iota, Z_{eff}')
xlabel('rho')

subplot(336);
plot(rho,g1N,'-',rho,g2N,'--')
title('g_1/(I_p^2/\mu_0), g_2/I_p^2*\mu_0)*R_0^2')
xlabel('rho')

subplot(337);
plot(rho,g3N)
title('g_3*R_0^2')
xlabel('rho')

subplot(338);
plot(rho,VpN,'-',rho,FN,'--',rho,HN,'-.')
title('V_p/V, F/R_0B_0, dpsidV/(\mu_I_p/V)')
xlabel('rho')


drawnow



return