function RAPTOR_plot_convergence(res_vec, timeslice, te_100s, q_100s, upl_100s)
% plotting function for stationary-state-finding routines
    set(0, 'defaulttextInterpreter', 'latex');
    set(0, 'defaultLegendInterpreter', 'latex');
    set(0, 'defaultAxesTickLabelInterpreter', 'latex');
    
    figure(1)
    
    hs(1) = subplot(231);
    hs(2) = subplot(232);
    hs(3) = subplot(233);
    hs(4) = subplot(234);
    hs(5) = subplot(235);
    hs(6) = subplot(236);

    rho = timeslice.rho;
    
    ax = hs(1);
    plot(ax, rho, 1e-3*timeslice.te, 'r', ...
             rho, 1e-3*te_100s, 'bd', 'LineWidth', 1.5, 'MarkerSize', 5);
    xlabel(ax, '$\hat{\rho}$'); 
    legend(ax, {'$T_e$ stationary','$T_e$ dynamic'}, 'Location', 'northeast', 'FontSize', 14);
    title(ax, '$T_e$ [$keV$] profiles');
    ax.FontSize = 14;
    
    ax = hs(2);
    plot(ax, rho, timeslice.q, 'r', ...
             rho, q_100s, 'bd', 'LineWidth', 1.5, 'MarkerSize', 5);
    xlabel(ax, '$\hat{\rho}$'); 
    legend(ax, {'$q$ stationary','$q$ dynamic'}, 'Location', 'northwest', 'FontSize', 14);
    title(ax, '$q$ profiles');
    ax.FontSize = 14;
    
    ax = hs(3);
    semilogy(ax, 1:numel(res_vec), res_vec, 'r-d', 'LineWidth', 1.5); 
    xlabel(ax, 'iteration'); 
    title(ax, 'norm evaluated equations');
    ax.FontSize = 14;
    
    ax = hs(4);
    plot(ax, rho, te_100s-timeslice.te, 'r', 'LineWidth', 1.5);
    xlabel(ax, '$\hat{\rho}$'); 
    title(ax, '$\Delta T_e$ [$eV$]');
    ax.FontSize = 14;
    
    ax = hs(5);
    plot(ax, rho, q_100s-timeslice.q, 'r', 'LineWidth', 1.5);
    xlabel(ax, '$\hat{\rho}$'); 
    title(ax, '$\Delta q$');
    ax.FontSize = 14;
         
    ax = hs(6);
    plot(ax, rho, upl_100s-timeslice.upl, 'r', 'LineWidth', 1.5);
    xlabel(ax, '$\hat{\rho}$');  
    title(ax, '$\Delta U_{pl}$ [$V$]');
    ax.FontSize = 14;
     
    
    st = suptitle('Dynamic ($1s$) and stationary RAPTOR run');
    st.FontSize = 16;
    
    set(gcf,'paperpositionmode','auto')

    set(gcf,'position',[100 100 1000 (2/3)*1000])

end