function pp = GUI_config_overview
pp = RAPTOR_plot_GUI; % get defaults

p = {}; % init
% Ip
p = [p,{struct('xdata','out.time','xlabel','t',...
    'ydata','out.Ip(end,:)' ,'ylabel','I_p[MA]','yscale',1e-6,'axesnr',1,'linestyle','-')}];

% Q
p = [p,struct('xdata','out.time','xlabel','t',...
    'ydata','out.Q' ,'ylabel','Q_{fus}','yscale',1,'axesnr',1,'linestyle','-')];

% q profile info
p = [p,struct('xdata','out.time','xlabel','t',...
    'ydata','out.qmin' ,'ylabel','q_{min}','yscale',1,'axesnr',2,'linestyle','-')];

p = [p,struct('xdata','out.time','xlabel','t',...
    'ydata','out.q0' ,'ylabel','q_0','yscale',1,'axesnr',2,'linestyle',':')];

p = [p,struct('xdata','out.time','xlabel','t',...
    'ydata','out.q95' ,'ylabel','q_{95}','yscale',1,'axesnr',2,'linestyle','--')];

% loop voltage
p = [p,struct('xdata','out.time','xlabel','t',...
    'ydata','out.upl(end,:)' ,'ylabel','V_{loop}[V]','yscale',1,'axesnr',3,'linestyle','-')];

% internal inductance
p = [p, struct('xdata','out.time','xlabel','t',...
    'ydata','out.li3(end,:)' ,'ylabel','li3','yscale',1,'axesnr',3,'linestyle','--')];


% temperature and density
p = [p,struct('xdata','out.time','xlabel','t',...
    'ydata','out.te(1,:)' ,'ylabel','T_{e0}[keV]','yscale',1e-3,'axesnr',4,'linestyle','-')];

p = [p,struct('xdata','out.time','xlabel','t',...
    'ydata','out.ti(1,:)' ,'ylabel','T_{i0}[keV]','yscale',1e-3,'axesnr',4,'linestyle','-.')];

p = [p,struct('xdata','out.time','xlabel','t',...
    'ydata','out.ne(1,:)' ,'ylabel','n_{e0}[10^{19}m^{-3}]','yscale',1e-19,'axesnr',4,'linestyle','--')];

% Figures of merit
%p = [p,struct('xdata','out.time','xlabel','t',...
%    'ydata','out.H98' ,'ylabel','H_{98y3}','yscale',1,'axesnr',5,'linestyle','--')];

p = [p,struct('xdata','out.time','xlabel','t',...
    'ydata','out.tauE' ,'ylabel','tau_E','yscale',1,'axesnr',5,'linestyle','--')];

p = [p,struct('xdata','out.time','xlabel','t',...
    'ydata','out.psi(end,:)' ,'ylabel','\psi_b','yscale',1,'axesnr',5,'linestyle',':')];


% input powers
p = [p, struct('xdata','out.time','xlabel','t',...
    'ydata','out.Pec(end,:)' ,'ylabel','\SigmaP_{ec}','yscale',1e-6,'axesnr',6,'linestyle','--')];

p = [p, struct('xdata','out.time','xlabel','t',...
    'ydata','out.Pnbe(end,:)' ,'ylabel','\SigmaP_{nbe}[MW]','yscale',1e-6,'axesnr',6,'linestyle','-.')];

p = [p, struct('xdata','out.time','xlabel','t',...
    'ydata','out.Pnbe(end,:)+out.Pnbi(end,:)' ,'ylabel','\Sigma(P_{nbe}+P_{nbi})[MW]','yscale',1e-6,'axesnr',6,'linestyle','-.')];

p = [p, struct('xdata','out.time','xlabel','t',...
    'ydata','out.Poh(end,:)' ,'ylabel','\SigmaP_{oh}','yscale',1e-6,'axesnr',6,'linestyle','-')];

p = [p, struct('xdata','out.time','xlabel','t',...
    'ydata','out.Palphatot(end,:)' ,'ylabel','\SigmaP_{\alpha}[MA]','yscale',1e-6,'axesnr',6,'linestyle',':')];

% Energies
% total thermal energy
p = [p,struct('xdata','out.time','xlabel','t',...
    'ydata','out.Wth' ,'ylabel','W_{th}','yscale',1e-6,'axesnr',7,'linestyle',':')];

% electron energy
p = [p,struct('xdata','out.time','xlabel','t',...
    'ydata','out.We' ,'ylabel','W_{e}','yscale',1e-6,'axesnr',7,'linestyle','-')];

% ion energy
p = [p,struct('xdata','out.time','xlabel','t',...
    'ydata','out.Wi' ,'ylabel','W_{i}','yscale',1e-6,'axesnr',7,'linestyle','--')];

% power losses
p = [p, struct('xdata','out.time','xlabel','t',...
    'ydata','out.Prad(end,:)' ,'ylabel','P_{rad}','yscale',1e-6,'axesnr',8,'linestyle','-')];

p = [p, struct('xdata','out.time','xlabel','t',...
    'ydata','out.Pbrem(end,:)' ,'ylabel','P_{brem}','yscale',1e-6,'axesnr',8,'linestyle','--')];

p = [p, struct('xdata','out.time','xlabel','t',...
    'ydata','out.Pei(end,:)' ,'ylabel','P_{ei}[MW]','yscale',1e-6,'axesnr',8,'linestyle','-.')];

% current components
p = [p, struct('xdata','out.time','xlabel','t',...
    'ydata','out.Ioh(end,:)' ,'ylabel','I_{oh}','yscale',1e-6,'axesnr',9,'linestyle','-')];

p = [p, struct('xdata','out.time','xlabel','t',...
    'ydata','out.Ibs(end,:)' ,'ylabel','I_{bs}','yscale',1e-6,'axesnr',9,'linestyle',':')];

p = [p, struct('xdata','out.time','xlabel','t',...
    'ydata','out.Inb(end,:)' ,'ylabel','I_{nb}','yscale',1e-6,'axesnr',9,'linestyle','--')];

p = [p, struct('xdata','out.time','xlabel','t',...
    'ydata','out.Iec(end,:)' ,'ylabel','I_{ec}','yscale',1e-6,'axesnr',9,'linestyle','-.')];


% beta
p = [p, struct('xdata','out.time','xlabel','t',...
    'ydata','out.beta' ,'ylabel','\beta','yscale',1,'axesnr',10,'linestyle','-')];

% p = [p, struct('xdata','out.time','xlabel','t',...
%     'ydata','out.betap' ,'ylabel','\beta_p','yscale',1,'axesnr',10,'linestyle','-.')];

p = [p, struct('xdata','out.time','xlabel','t',...
    'ydata','out.betaN' ,'ylabel','\beta_N','yscale',1,'axesnr',10,'linestyle','--')];

% profiles

% Upl
p = [p, struct(...
    'xdata','out.rho',      'xlabel','\rho',...
    'ydata','out.upl(:,%i)','ylabel','U_{pl}[V]','yscale',1,'axesnr',11,'linestyle','-')];

% q and shear
p = [p, struct('xdata','out.rho','xlabel','\rho',...
    'ydata','out.q(:,%i)' ,'ylabel','q','yscale',1,'axesnr',12,'linestyle','-')];

p = [p, struct('xdata','out.rho','xlabel','\rho',...
    'ydata','out.shear(:,%i)' ,'ylabel','shear','yscale',1,'axesnr',12,'linestyle','--')];

% power loss distributions
p = [p, struct('xdata','out.rho','xlabel','\rho',...
    'ydata','out.prad(:,%i)' ,'ylabel','p_{rad}[MW/m^3]','yscale',1e-6,'axesnr',13,'linestyle','-')];

p = [p, struct('xdata','out.rho','xlabel','\rho',...
    'ydata','out.pbrem(:,%i)' ,'ylabel','p_{brem}[MW/m^3]','yscale',1e-6,'axesnr',13,'linestyle','--')];

p = [p, struct('xdata','out.rho','xlabel','\rho',...
    'ydata','out.pei(:,%i)' ,'ylabel','p_{ei}[MW/m^3]','yscale',1e-6,'axesnr',13,'linestyle','-.')];

% driven currents
%p = [p, struct('xdata','out.rho','xlabel','\rho',...
%    'ydata','out.jaux(:,%i)' ,'ylabel','j_{cd}','yscale',1e-6,'axesnr',14,'linestyle','-')];

p = [p, struct('xdata','out.rho','xlabel','\rho',...
    'ydata','out.jec(:,%i)' ,'ylabel','j_{ec}','yscale',1e-6,'axesnr',14,'linestyle','--')];

p = [p, struct('xdata','out.rho','xlabel','\rho',...
    'ydata','out.jnb(:,%i)' ,'ylabel','j_{nb}','yscale',1e-6,'axesnr',14,'linestyle','-.')];

p = [p, struct('xdata','out.rho','xlabel','\rho',...
    'ydata','out.jbs(:,%i)' ,'ylabel','j_{bs}[MA/m^2]','yscale',1e-6,'axesnr',14,'linestyle',':')];

p = [p, struct('xdata','out.rho','xlabel','\rho',...
    'ydata','out.joh(:,%i)' ,'ylabel','j_{oh}[MA/m^2]','yscale',1e-6,'axesnr',14,'linestyle','-')];


%         % cumulative current components
%         p = [p, struct('xdata','out.rho','xlabel','\rho',...
%             'ydata','out.joh(:,%i)' ,'ylabel','j_{\Omega}','yscale',1e-6,'axesnr',15,'linestyle','-')];
%
%         callstr = 'subsref(out.joh+out.jbs,struct(''type'',''()'',''subs'',{{'':'',%i}}))';
%         p = [p, struct('xdata','out.rho','xlabel','\rho',...
%             'ydata', callstr ,'ylabel','+j_{bs}','yscale',1e-6,'axesnr',15,'linestyle','--')];
%
%         callstr = 'subsref(out.joh+out.jbs+out.jaux,struct(''type'',''()'',''subs'',{{'':'',%i}}))';
%         p = [p, struct('xdata','out.rho','xlabel','\rho',...
%             'ydata',callstr,'ylabel','+j_{aux}[MA/m^2]','yscale',1e-6,'axesnr',15,'linestyle','-')];
%

% zeff
p = [p, struct('xdata','out.rho','xlabel','\rho',...
    'ydata','out.ze(:,%i)' ,'ylabel','Z_{eff}','yscale',1,'axesnr',15,'linestyle','-')];

% conductivity
p = [p, struct('xdata','out.rho','xlabel','\rho',...
    'ydata','out.signeo(:,%i)' ,'ylabel','\sigma_{||}[m\Omegam]','yscale',1e-6,'axesnr',15,'linestyle','-')];

% kinetic profiles
p = [p, struct('xdata','out.rho','xlabel','\rho',...
    'ydata','out.te(:,%i)' ,'ylabel','T_e[keV]','yscale',1e-3,'axesnr',16,'linestyle','-')];

p = [p, struct('xdata','out.rho','xlabel','\rho',...
    'ydata','out.ti(:,%i)' ,'ylabel','T_i[keV]','yscale',1e-3,'axesnr',16,'linestyle','--')];


% iota profile
p = [p, struct('xdata','out.rho','xlabel','\rho',...
    'ydata','out.iota(:,%i)' ,'ylabel','\iota=1/q','yscale',1,'axesnr',17,'linestyle','-')];


% density
p = [p, struct('xdata','out.rho','xlabel','\rho',...
    'ydata','out.ne(:,%i)' ,'ylabel','n_{e}[10^{19}m^{-3}]','yscale',1e-19,'axesnr',18,'linestyle','-')];

p = [p, struct('xdata','out.rho','xlabel','\rho',...
    'ydata','out.ni(:,%i)' ,'ylabel','n_{i}[10^{19}m^{-3}]','yscale',1e-19,'axesnr',18,'linestyle',':')];

% power density components
p = [p, struct('xdata','out.rho','xlabel','\rho',...
    'ydata','out.poh(:,%i)' ,'ylabel','p_{\Omega}','yscale',1e-6,'axesnr',19,'linestyle','-')];

callstr = 'out.palphae(:,%i)';
p = [p, struct('xdata','out.rho','xlabel','\rho',...
    'ydata', callstr ,'ylabel','p_{\alpha}','yscale',1e-6,'axesnr',19,'linestyle',':')];

callstr = 'out.pnbe(:,%i)';
p = [p, struct('xdata','out.rho','xlabel','\rho',...
    'ydata',callstr,'ylabel','p_{nbe}[MW/m^3]','yscale',1e-6,'axesnr',19,'linestyle','-.')];

callstr = 'out.pnbi(:,%i)';
p = [p, struct('xdata','out.rho','xlabel','\rho',...
    'ydata',callstr,'ylabel','p_{nbi}[MW/m^3]','yscale',1e-6,'axesnr',19,'linestyle','-.')];

callstr = 'out.pec(:,%i)';
p = [p, struct('xdata','out.rho','xlabel','\rho',...
    'ydata',callstr,'ylabel','p_{ec}[MW/m^3]','yscale',1e-6,'axesnr',19,'linestyle','--')];

% chi
p = [p, struct('xdata','out.rhogauss','xlabel','\rho',...
    'ydata','out.chiegauss(:,%i)' ,'ylabel','\chi_e[m^2/s]','yscale',1,'axesnr',20,'linestyle','-')];

p = [p, struct('xdata','out.rhogauss','xlabel','\rho',...
    'ydata','out.chiigauss(:,%i)' ,'ylabel','\chi_i[m^2/s]','yscale',1,'axesnr',20,'linestyle','--')];

% automatically spaced positions for axes
pp.plots = p; % reassign
pp.axes =  axespos(5,4,[0.05 0.05],[0.05 0.05],[0.05 0.05]);
end