function pp = GUI_config_hcd
pp = RAPTOR_plot_GUI; % get defaults

p={}; % init
% Ip
ax = 1;
p = [p,{struct('xdata','out.time','xlabel','t',...
    'ydata','out.Ip(end,:)' ,'ylabel','I_p[MA]','yscale',1e-6,'axesnr',ax,'linestyle','-')}];

% loop voltage
p = [p,struct('xdata','out.time','xlabel','t',...
    'ydata','out.upl(end,:)' ,'ylabel','V_{loop}[V]','yscale',1,'axesnr',ax,'linestyle','-')];

% internal inductance
p = [p, struct('xdata','out.time','xlabel','t',...
    'ydata','out.li3(end,:)' ,'ylabel','li3','yscale',1,'axesnr',ax,'linestyle','--')];

% q profile info
ax = 2;
p = [p,struct('xdata','out.time','xlabel','t',...
    'ydata','out.qmin' ,'ylabel','q_{min}','yscale',1,'axesnr',ax,'linestyle','-')];

p = [p,struct('xdata','out.time','xlabel','t',...
    'ydata','out.q0' ,'ylabel','q_0','yscale',1,'axesnr',ax,'linestyle',':')];

p = [p,struct('xdata','out.time','xlabel','t',...
    'ydata','out.q95' ,'ylabel','q_{95}','yscale',1,'axesnr',ax,'linestyle','--')];

% temperature and density
ax = 3;
p = [p,struct('xdata','out.time','xlabel','t',...
    'ydata','out.te(1,:)' ,'ylabel','T_{e0}[keV]','yscale',1e-3,'axesnr',ax,'linestyle','-')];

p = [p,struct('xdata','out.time','xlabel','t',...
    'ydata','out.ti(1,:)' ,'ylabel','T_{i0}[keV]','yscale',1e-3,'axesnr',ax,'linestyle','--')];

p = [p,struct('xdata','out.time','xlabel','t',...
    'ydata','out.ne(1,:)' ,'ylabel','n_{e0}[10^{19}m^{-3}]','yscale',1e-19,'axesnr',ax,'linestyle','-.')];

p = [p,struct('xdata','out.time','xlabel','t',...
    'ydata','out.ni(1,:)' ,'ylabel','n_{i0}[10^{19}m^{-3}]','yscale',1e-19,'axesnr',ax,'linestyle',':')];


% input powers
ax = 4;
p = [p, struct('xdata','out.time','xlabel','t',...
    'ydata','out.Pec(end,:)' ,'ylabel','\SigmaP_{ec}','yscale',1e-6,'axesnr',ax,'linestyle','--')];

p = [p, struct('xdata','out.time','xlabel','t',...
    'ydata','out.Pnbe(end,:)' ,'ylabel','\SigmaP_{nbe}[MW]','yscale',1e-6,'axesnr',ax,'linestyle','-.')];

p = [p, struct('xdata','out.time','xlabel','t',...
    'ydata','out.Pnbi(end,:)' ,'ylabel','\SigmaP_{nbi}[MW]','yscale',1e-6,'axesnr',ax,'linestyle','-.')];

p = [p, struct('xdata','out.time','xlabel','t',...
    'ydata','out.Pice(end,:)' ,'ylabel','\SigmaP_{ice}[MW]','yscale',1e-6,'axesnr',ax,'linestyle',':')];

p = [p, struct('xdata','out.time','xlabel','t',...
    'ydata','out.Pici(end,:)' ,'ylabel','\SigmaP_{ici}[MW]','yscale',1e-6,'axesnr',ax,'linestyle',':')];

p = [p, struct('xdata','out.time','xlabel','t',...
    'ydata','out.Poh(end,:)' ,'ylabel','\SigmaP_{oh}','yscale',1e-6,'axesnr',ax,'linestyle','-')];

p = [p, struct('xdata','out.time','xlabel','t',...
    'ydata','out.Palphatot(end,:)' ,'ylabel','\SigmaP_{\alpha}[MA]','yscale',1e-6,'axesnr',ax,'linestyle',':')];

% current components
ax = 5
p = [p, struct('xdata','out.time','xlabel','t',...
    'ydata','out.Ioh(end,:)' ,'ylabel','I_{oh}','yscale',1e-6,'axesnr',ax,'linestyle','-')];

p = [p, struct('xdata','out.time','xlabel','t',...
    'ydata','out.Ibs(end,:)' ,'ylabel','I_{bs}','yscale',1e-6,'axesnr',ax,'linestyle',':')];

p = [p, struct('xdata','out.time','xlabel','t',...
    'ydata','out.Inb(end,:)' ,'ylabel','I_{nb}','yscale',1e-6,'axesnr',ax,'linestyle','--')];

p = [p, struct('xdata','out.time','xlabel','t',...
    'ydata','out.Iec(end,:)' ,'ylabel','I_{ec}','yscale',1e-6,'axesnr',ax,'linestyle','-.')];

% Upl
ax = 6;
p = [p, struct(...
    'xdata','out.rho',      'xlabel','\rho',...
    'ydata','out.upl(:,%i)','ylabel','U_{pl}[V]','yscale',1,'axesnr',ax,'linestyle','-')];

% q and shear
p = [p, struct('xdata','out.rho','xlabel','\rho',...
    'ydata','out.q(:,%i)' ,'ylabel','q','yscale',1,'axesnr',ax,'linestyle','-')];

p = [p, struct('xdata','out.rho','xlabel','\rho',...
    'ydata','out.shear(:,%i)' ,'ylabel','shear','yscale',1,'axesnr',ax,'linestyle','--')];
% rational surfaces
p = [p, struct('xdata','out.rho','xlabel','\rho',...
    'ydata','[1]*ones(size(out.rho))' ,'ylabel','','yscale',1,'axesnr',ax,'linestyle',':')];
p = [p, struct('xdata','out.rho','xlabel','\rho',...
    'ydata','[2]*ones(size(out.rho))' ,'ylabel','','yscale',1,'axesnr',ax,'linestyle',':')];
p = [p, struct('xdata','out.rho','xlabel','\rho',...
    'ydata','[3]*ones(size(out.rho))' ,'ylabel','','yscale',1,'axesnr',ax,'linestyle',':')];


% driven currents
%p = [p, struct('xdata','out.rho','xlabel','\rho',...
%    'ydata','out.jaux(:,%i)' ,'ylabel','j_{cd}','yscale',1e-6,'axesnr',14,'linestyle','-')];
ax = 8;
p = [p, struct('xdata','out.rho','xlabel','\rho',...
    'ydata','out.jec(:,%i)' ,'ylabel','j_{ec}','yscale',1e-6,'axesnr',ax,'linestyle','--')];

p = [p, struct('xdata','out.rho','xlabel','\rho',...
    'ydata','out.jnb(:,%i)' ,'ylabel','j_{nb}','yscale',1e-6,'axesnr',ax,'linestyle','-.')];

p = [p, struct('xdata','out.rho','xlabel','\rho',...
    'ydata','out.jbs(:,%i)' ,'ylabel','j_{bs}[MA/m^2]','yscale',1e-6,'axesnr',ax,'linestyle',':')];

p = [p, struct('xdata','out.rho','xlabel','\rho',...
    'ydata','out.joh(:,%i)' ,'ylabel','j_{oh}[MA/m^2]','yscale',1e-6,'axesnr',ax,'linestyle','--')];

p = [p, struct('xdata','out.rho','xlabel','\rho',...
    'ydata','out.jpar(:,%i)' ,'ylabel','j_{||}[MA/m^2]','yscale',1e-6,'axesnr',ax,'linestyle','-')];


%         % cumulative current components
%         p = [p, struct('xdata','out.rho','xlabel','\rho',...
%             'ydata','out.joh(:,%i)' ,'ylabel','j_{\Omega}','yscale',1e-6,'axesnr',15,'linestyle','-')];
%
%         callstr = 'subsref(out.joh+out.jbs,struct(''type'',''()'',''subs'',{{'':'',%i}}))';
%         p = [p, struct('xdata','out.rho','xlabel','\rho',...
%             'ydata', callstr ,'ylabel','+j_{bs}','yscale',1e-6,'axesnr',15,'linestyle','--')];
%
%         callstr = 'subsref(out.joh+out.jbs+out.jaux,struct(''type'',''()'',''subs'',{{'':'',%i}}))';
%         p = [p, struct('xdata','out.rho','xlabel','\rho',...
%             'ydata',callstr,'ylabel','+j_{aux}[MA/m^2]','yscale',1e-6,'axesnr',15,'linestyle','-')];
%
ax = 9;
% kinetic profiles
p = [p, struct('xdata','out.rho','xlabel','\rho',...
    'ydata','out.te(:,%i)' ,'ylabel','T_e[keV]','yscale',1e-3,'axesnr',ax,'linestyle','-')];

p = [p, struct('xdata','out.rho','xlabel','\rho',...
    'ydata','out.ti(:,%i)' ,'ylabel','T_i[keV]','yscale',1e-3,'axesnr',ax,'linestyle','--')];


% density
p = [p, struct('xdata','out.rho','xlabel','\rho',...
    'ydata','out.ne(:,%i)' ,'ylabel','n_{e}[10^{19}m^{-3}]','yscale',1e-19,'axesnr',ax,'linestyle','-')];

p = [p, struct('xdata','out.rho','xlabel','\rho',...
    'ydata','out.ni(:,%i)' ,'ylabel','n_{i}[10^{19}m^{-3}]','yscale',1e-19,'axesnr',ax,'linestyle',':')];

ax = 7;
% power density components
p = [p, struct('xdata','out.rho','xlabel','\rho',...
    'ydata','out.poh(:,%i)' ,'ylabel','p_{\Omega}','yscale',1e-6,'axesnr',ax,'linestyle','-')];

callstr = 'out.palphae(:,%i)';
p = [p, struct('xdata','out.rho','xlabel','\rho',...
    'ydata', callstr ,'ylabel','p_{\alpha}','yscale',1e-6,'axesnr',ax,'linestyle',':')];

callstr = 'out.pnbe(:,%i)';
p = [p, struct('xdata','out.rho','xlabel','\rho',...
    'ydata',callstr,'ylabel','p_{nbe}[MW/m^3]','yscale',1e-6,'axesnr',ax,'linestyle','-.','marker','o')];

callstr = 'out.pnbi(:,%i)';
p = [p, struct('xdata','out.rho','xlabel','\rho',...
    'ydata',callstr,'ylabel','p_{nbi}[MW/m^3]','yscale',1e-6,'axesnr',ax,'linestyle','-.','marker','.')];

callstr = 'out.pice(:,%i)';
p = [p, struct('xdata','out.rho','xlabel','\rho',...
    'ydata',callstr,'ylabel','p_{ice}[MW/m^3]','yscale',1e-6,'axesnr',ax,'linestyle','-.','marker','x')];

callstr = 'out.pici(:,%i)';
p = [p, struct('xdata','out.rho','xlabel','\rho',...
    'ydata',callstr,'ylabel','p_{ici}[MW/m^3]','yscale',1e-6,'axesnr',ax,'linestyle','-.','marker','s')];


callstr = 'out.pec(:,%i)';
p = [p, struct('xdata','out.rho','xlabel','\rho',...
    'ydata',callstr,'ylabel','p_{ec}[MW/m^3]','yscale',1e-6,'axesnr',ax,'linestyle','--')];

% automatically spaced positions for axes
pp.plots = p; % reassign
pp.axes =  axespos(3,3,[0.05 0.05],[0.05 0.05],[0.05 0.05]);

end