function pp = GUI_config_geometry
% plots related to geometry
pp = RAPTOR_plot_GUI; % get defaults

% simple plots with some key quantities
p = {}; % init
p = [p,{struct('xdata','out.time','xlabel','t',...
    'ydata','out.Ip(end,:)' ,'ylabel','I_p[MA]','yscale',1e-6,'axesnr',1,'linestyle','-')}];

p = [p,struct('xdata','out.rho','xlabel','\rho',...
    'ydata','out.g1(:,%i)' ,'ylabel','g1','yscale',1,'axesnr',2,'linestyle','-')];

p = [p,struct('xdata','out.rho','xlabel','\rho',...
    'ydata','out.g2(:,%i)' ,'ylabel','g2','yscale',1,'axesnr',3,'linestyle','-')];

p = [p,struct('xdata','out.rho','xlabel','\rho',...
    'ydata','out.g3(:,%i)' ,'ylabel','g3','yscale',1,'axesnr',4,'linestyle','-')];

p = [p,struct('xdata','out.rho','xlabel','\rho',...
    'ydata','out.Vp(:,%i)' ,'ylabel','Vprime','yscale',1','axesnr',5,'linestyle','-');];

p = [p,struct('xdata','out.rho','xlabel','\rho',...
    'ydata','out.F(:,%i)' ,'ylabel','F=RB_\phi','yscale',1','axesnr',6,'linestyle','-');];

p = [p,struct('xdata','out.rho','xlabel','\rho',...
    'ydata','out.g23or(:,%i)','ylabel','g_2g_3/\rho','yscale',1','axesnr',9,'linestyle','-');];

p = [p,struct('xdata','out.time','xlabel','\rho',...
    'ydata','out.Phib','ylabel','\Phib','yscale',1','axesnr',7,'linestyle','-');];

p = [p,struct('xdata','out.time','xlabel','\rho',...
    'ydata','out.Volume(end,:)','ylabel','Volume','yscale',1','axesnr',8,'linestyle','-');];

p = [p,struct('xdata','out.time','xlabel','\rho',...
    'ydata','out.g23or(end,:)/100','ylabel','g2g3/r(end)','yscale',1','axesnr',8,'linestyle','--');];


pp.plots = p; % reassign

% axes position definitions
pp.axes = axespos(3,3,[0.05 0.05],[0.05 0.05],[0.05,0.05]);
