%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Manual Vp and Dn
function varargout = vpdn_manual(varargin)
if nargin == 0,
  varargout{1} = 'vpdn_e'; % type;
  varargout{2} = [];
  return
elseif nargin==2
  %% DEFAULT PARAMETERS
  module_params=struct(...
    'dne_pr'  ,  1., ... % prescribed Dne: constant (default), fixed profile (rho_gauss), time-varying, [] to use coeff*chi_e
    'vpe_pr'  , -5., ... % prescribed Vpe: constant (default), fixed profile (rho_gauss), time-varying, [] to use coeff*Dne
    'implicit',true ...
    );
  
  mm.name = mfilename;
  varargout{1} = mm;
  varargout{2} = module_params;
  return %empty call, probably to get default structures
elseif nargin==6;
  %stap   = varargin{1};
  %geop   = varargin{2};
  %trap   = varargin{3};
  it     = varargin{4};
  model  = varargin{5};
  vdp = varargin{6};
else
  error('must call with 0 or 6 inputs');
end

% Dne
if (size(vdp.dne_pr,2)==1)&&(size(vdp.dne_pr,1)==1)
  % Constant Dne
  Dne = vdp.dne_pr*ones(model.rgrid.nrhogauss,1);
elseif (size(vdp.dne_pr,2)==1)&&(size(vdp.dne_pr,1)~=1)
  % Fixed profile on rho_gauss
  Dne = vdp.dne_pr;
else
  % Time-varying Dne
  Dne = vdp.dne_pr(:,it);
end
% Vne
if (size(vdp.vpe_pr,2)==1)&&(size(vdp.vpe_pr,1)==1)
  % Constant Vpe
  Vpe = vdp.vpe_pr*ones(model.rgrid.nrhogauss,1);
elseif (size(vdp.vpe_pr,2)==1)&&(size(vdp.vpe_pr,1)~=1)
  % Fixed profile on rho_gauss
  Vpe = vdp.vpe_pr;
else
  % Time-varying Vpe
  Vpe = vdp.vpe_pr(:,it);
end

varargout{1} = Dne;
varargout{2} = Vpe;
end