function varargout = vpdn_QLKNN10D(varargin)
% wrapper for vpdn from QLKNN in case of qlkNN10D

QLKNNtype = 'QLKNN10D';
if nargin==0
  varargout{1} = 'vpdn_e';
  varargout{2} = [];
  return
elseif nargin==2
  [QLKNNnet,QLKNNparams] = QLKNN(QLKNNtype);
  QLKNNparams.calc_heat_transport = false;
  QLKNNparams.calc_part_transport = true;
  mm.name = mfilename;
  mm.QLKNNnet = QLKNNnet;
  varargout{1} = mm;
  varargout{2} = QLKNNparams;
  return
elseif nargin==6
  stap = varargin{1};
  geop = varargin{2};
  trap = varargin{3};
  %it = varargin{4};
  model = varargin{5};
  QLKNNparams = varargin{6}; % distribute inputs
  
  QLKNNnet = model.vpdn_e.QLKNNnet;
  
  [varargout{1},varargout{2}] = ...
    QLKNN(stap,geop,trap,model,QLKNNnet,QLKNNparams);
else
  error('invalid number of input arguments');
end