function varargout = chi_manual(varargin)

if nargin == 0,
  varargout{1} = 'chi_e'; % type
  varargout{2} = []; % no config for this module
  return
elseif nargin==2
  %% pass params and model
  %% model
  mm.name = mfilename;
  mm.type = 'chi_e';
  
  varargout{1} = mm;
  module_params= struct(...
    'chi_e',10,... % default constant
    'chi_i',10,...
    'implicit',false); % default constant
  varargout{2} = module_params;
  return
elseif nargin==6 % change this depending on number of inputs to module
  %stap = varargin{1};
  %geop = varargin{2};
  %trap = varargin{3};
  it = varargin{4};
  model = varargin{5};
  pp = varargin{6}; % distribute inputs
else
    error('must call with 0 or 6 inputs');
end

chie = parse_chi(pp.chi_e,it,model);
chii = parse_chi(pp.chi_i,it,model);

zz = zeros(numel(chie),model.dims.nx);
zu = zeros(numel(chie),model.dims.nu);

varargout{1} = chie;
varargout{2} = chii;
varargout{3} = zz;
varargout{4} = zz;
varargout{5} = zz;
varargout{6} = zz;
varargout{7} = zu;
varargout{8} = zu;

end


function chie = parse_chi(chi_e,it,model)
if numel(chi_e)==1  % for constant profile
  chie = chi_e*ones(model.rgrid.nrhogauss,1);
elseif size(chi_e,1) == model.rgrid.nrhogauss ...
    && size(chi_e,2) >= 2 % for time-dependent profile: use matrix cneo # rhogauss by timegrid
  if size(chi_e,2) >= it
    chie = chi_e(:,it);
  else
    error('wrong size for time-dependent manual chie, must at least be [%d x %d]',model.rgrid.nrhogauss,it);
  end
else
  chie = chi_e; % Rho-dependent but time-independent profile
  assert(numel(chie)==model.rgrid.nrhogauss,...
    'wrong numel for fixed manual chie, found %d, must be %d',numel(chie),model.rgrid.nrhogauss);
end
end