function success = qlknn_convert_jsons(qlknnNamelistPath, varargin)
  % Set up paths to all needed scripts/files
  RAPTORpath = RAPTOR_path();
  qlknnPath = fullfile(RAPTORpath,'submodules','QLKNN-fortran');
  qlknnJsonPath = fullfile(RAPTORpath, 'submodules','qlknn-hyper');
  to_namelist = fullfile(qlknnPath, 'tools','json_nn_to_namelist.py');
  
  if nargin>=2
    verbose = varargin{1};
  else
    verbose = false;
  end
  
  % Look for jsons to convert
  f = dir(fullfile(qlknnJsonPath, '*.json'));
  n = length(f);
  assert(n==20,'Not enough networks found, found %d instead of 20', n)
  
  % Create target dir if it does not exist
  if ~exist(qlknnNamelistPath, 'dir')
    mkdir(qlknnNamelistPath)
  end
  
  % Run Python script to generate namelists
  cmd = ['python ' to_namelist ' ' qlknnJsonPath ' ' qlknnNamelistPath];
  if verbose
    cmd = [cmd ' --verbose'];
  end
  [status,~] = system(cmd, '-echo');
  
  if (status == 0)
    success = true;
  else
    success = false;
  end
end
