function passed = writestruct_to_mfile_test()

% a challenging structure
STest{1} = struct('x',rand(1),...
  'y',int16(2),...
  'z',rand(3),...
  'n',2,...
  'r',struct('x',1,'y',2),...
  's','bla',...
  'a',int16(rand(1,4)),...
  'b',[true;false],...
  'es',struct(),...
  'c',{{1,{{2,3}},rand(2),num2cell(rand(2))}},...
  'cs',{{1,struct('a',1,'b',struct('c','cc','a',{{1,2,3}}))}},... % cell containing struct with nested struct with cell
  'sa',struct(repmat(struct('a',1,'b',2),3,2))); % array of structures

clear functions

%% write to .m file
for itest = numel(STest)
S = orderfields(STest{itest});

% mk dir
fdir = '/tmp/genlib-test/';
cmd = sprintf('mkdir -p %s',fdir);
s=system(cmd); assert(~s,'%s failed',cmd);

% write file
fname = fullfile(fdir,'testStruct.m');
ok=writestruct_to_mfile(S,fname);
assert(ok,'error writing structure')
%% read
assert(~~exist(fname,'file'),'%s does not exist',fname);
addpath(fdir)
Sout = eval('testStruct');

%% test that they are equal
pass(itest) = structcmp(S,Sout,1e-5);

%% remove test artefact
delete(fname);
end
system('rm -rf /tmp/genlib-test');

passed = all(pass);

end
