function outs = time2slice(out,tind)
% Create out structure for single time=out.time(tind).
% out: RAPTOR output 
% tind: time index
%
% outs: RAPTOR output with one time slice
eval_tind = @(M,tind) M(:,tind);

skipfields = {'rho','rhogauss','ntime','nrho','ngauss'};

fields = fieldnames(out);
for ifields = 1:numel(fields)
 myfield = fields{ifields};
 for ii=1:numel(skipfields)
   if isequal(myfield,skipfields{ii})
     skip = true; break;
   else
     skip = false;
   end
 end
 if skip 
   outs.(myfield) = out.(myfield); 
 else
   if size(out.(myfield),2)==numel(out.time)
     outs.(myfield) = eval_tind(out.(myfield), tind); % copy to second time slice
   else
     outs.(myfield) = out.(myfield);
   end
 end
end
outs.ntime = 1;
end
