function  src = src_unpack(src_matrix)
% unpack src matrix into src structure (for displays etc)
% diffusion coefficients.
% This must match the assignment of src in state_equation.m and the size in
% model.dims.nsrc defined in build_RAPTOR_model.m

src.chie = src_matrix(:,1);
src.signeo = src_matrix(:,2);

% input powers
src.poh = src_matrix(:,3);
src.pec = src_matrix(:,4);
src.pnbe = src_matrix(:,5); % nbi power to electrons
src.pnbi = src_matrix(:,6); % nbi power to ions
src.plh = src_matrix(:,7);
src.pice = src_matrix(:,8);
src.paux = src_matrix(:,9);
src.palphae = src_matrix(:,10);
src.palphai = src_matrix(:,11);
src.pbrem = src_matrix(:,12);
src.pei = src_matrix(:,13);
src.prad = src_matrix(:,14);

% auxiliary currents
src.jbsB =  src_matrix(:,15); 
src.jecB = src_matrix(:,16);
src.jnbB = src_matrix(:,17);
src.jlhB = src_matrix(:,18);
src.jicB = src_matrix(:,19);
src.jauxB = src_matrix(:,20);
src.jphioR = src_matrix(:,21);
