function [staps,traps,geops] = src2stg(src_matrix,simres,model)
% [staps,traps,geops] = src2stg(src_matrix,simres,model)
% 
% for Simulink cases where only src is stored in the logs, rewrite to
% stap,trap,geop format for compatibility with RAPTOR_out.m

% F. Felici TU/e 2017
%%
stap0 = init_stap(model);
trap0 = init_trap(model);
geop0 = init_geop(model);
B0 = geop0.B0; 
nt = size(simres.X,2);


for it=1:nt
    %%
    src = src_unpack(src_matrix(:,:,it));
    x = simres.X(:,it);
    xdot = simres.Xdot(:,it);
    g = simres.G(:,it);
    v = simres.V(:,it);
    if it>1
        gdot = simres.G(:,it)-simres.G(:,it-1);
        vdot = simres.V(:,it)-simres.V(:,it-1);
    else
        gdot = 0*g;
        vdot = 0*v;
    end
        
    %%
    mytrap = trap0;
    mytrap.chie = src.chie;
    mytrap.signeo = src.signeo;
    mytrap.poh = src.poh;
    mytrap.pec = src.pec;
    mytrap.pnbe = src.pnbe;
    mytrap.pnbi = src.pnbi; 
    mytrap.plh = src.plh;
    mytrap.pice = src.pice;
    mytrap.paux = src.paux;
    mytrap.palphae = src.palphae;
    mytrap.palphai = src.palphai;
    mytrap.pbrem = src.pbrem;
    mytrap.pei = src.pei;
    mytrap.prad = src.prad;
    mytrap.jbsB = src.jbsB;
    mytrap.jecB = src.jecB;
    mytrap.jnbB = src.jnbB;
    mytrap.jlhB = src.jlhB;
    mytrap.jbsB = src.jbsB;
    mytrap.jicB = src.jicB;   
    mytrap.jauxB = src.jauxB;
    mytrap.jbs = src.jbsB/B0;
    mytrap.jec = src.jecB/B0;
    mytrap.jnb = src.jnbB/B0;
    mytrap.jlh = src.jlhB/B0;
    mytrap.jbs = src.jbsB/B0;
    mytrap.jic = src.jicB/B0;   
    mytrap.jaux = src.jauxB/B0;   
    mytrap.jphioR = src.jphioR;  
    
    %%
    mystap = state_profiles(x,xdot,g,gdot,v,vdot,model,stap0);
    mygeop = geometry_profiles(g,gdot,model,geop0);
    B0 = mygeop.B0;
    
    %%
    traps{it} = mytrap;
    staps{it} = mystap;
    geops{it} = mygeop;
end