function out = rad_conf_plh_post_processing(config, model, out, simres)
% calculate: 
% -- PLH with plasma area to input
% -- vol avg Zeff
% -- Pradcore = .6*Prad75 H Lux et al 2016 Plasma Phys. Control. Fusion 58 075001
% -- frad
% -- tauE_rad, tauE_H98_rad, H98_rad (based on Ploss-Pradcore)
% geometric formulas from Sauter FED 2016
% chease_data.eqdsk.syscode_formulas from equilibria
% 1. R0, 2. a_minor, 3. epsilon, 4. kappa: 1.7173, 5. delta, 6. w07: 0.8478

neq = numel(config.equi.times);
sysgeom = zeros(6, neq);
dir = config.envopts.equil_path;
for ii = 1:neq
  fn = config.equi.filenames{ii};
  load(strcat(dir,'/',fn))
  if ii == 1 
    if isfield(chease_data, 'eqdsk') && isfield(chease_data.eqdsk, 'syscode_formulas')
      flg_syscode_formulas = true;
    else
      flg_syscode_formulas = false;
      disp('field chease_data.eqdsk.syscode_formulas does not exist')
      break
    end
  end
  aa = chease_data.eqdsk.syscode_formulas;
  sysgeom(1,ii) = aa.R0;
  sysgeom(2,ii) = aa.a_minor;
  sysgeom(3,ii) = aa.epsilon;
  sysgeom(4,ii) = aa.kappa;
  sysgeom(5,ii) = aa.delta;
  sysgeom(6,ii) = aa.w07;
end
if neq>1
  geomt = interp1(config.equi.times, sysgeom', out.time, 'linear', 'extrap')';
else
  geomt = repmat(sysgeom, 1, numel(out.time));
end
if flg_syscode_formulas
  L = 2*pi*geomt(2,:).*(1+0.55*(geomt(4,:)-1)).*(1+0.08*geomt(5,:).^2).*(1+0.2*(geomt(6,:)-1));
  A = 2*pi*geomt(1,:).*(1-0.32.*geomt(5,:).*geomt(3,:)).*L;
  out.PLHalt = 0.0488e6 .* out.ne20_line_av.^0.717 .* out.B0.^0.803 .* A.^0.941*2 ./ model.atom.Ai;
  % careful: different from the standard PLH evaluated by RAPTOR
  % orinally, out.PLH was overwritten, so take care in interpretation
end

zevolav = zeros(1, numel(out.time));
Pradcore = zeros(1, numel(out.time));
for ii=1:numel(out.time)
  zeg = eval_ze(simres.X(:,ii), simres.G(:,ii), simres.V(:,ii), model, true);
  geop = simres.geops{ii};
  zevolav(ii) = int_Vtot(zeg, geop, model)/out.Volume(end,ii);
  Int_prad = int_Vfrom_geop(out.pradgauss(:,ii)+out.pbremgauss(:,ii),geop,model);
  Prad75 = interp1(model.rgrid.rho, Int_prad, .75);
  Pradcore(ii) = .6*Prad75; % H Lux et al 2016 Plasma Phys. Control. Fusion 58 075001
end
out.zevol = zevolav;
out.Pradcore = Pradcore;

out.frad = (out.Prad+out.Pbrem) ./ (out.Pfusion/5 + out.Pauxtot + out.Poh);

out.tauE_rad = out.Wth./(out.Ploss - out.Pradcore); 
epsilon = out.epsilon(end,:);
kappa   = out.kappa(end,:);

out.tauE_H98_rad = eval_tauEH98_from_traces(out.Ip(end,:), out.B0, out.ne(1,:), out.Ploss-out.Pradcore, model.equi.R0, epsilon, kappa, model.atom.Ai);

out.H98_rad = out.tauE_rad./out.tauE_H98_rad;
end