function out = RAPTOR_out_persignal(xk,xkdot,gk,vk,uk,srcs,model,params,signalname)
% get RAPTOR output for given signal list
%#codegen
src = src_unpack(srcs);

switch signalname
  case 'B0'
    out = eval_B0(xk,gk,vk,model,false);
  case 'rho'
    out = model.rgrid.rho;
  case 'rhogauss'
    out = model.rgrid.rhogauss;
  case 'psi'
    out  = eval_psi(xk,[],[],model,false);
  case 'psip'
    out  = eval_psip(xk,[],[],model,false);
  case 'te'
    out  = eval_te(xk,[],[],model,false);
  case 'tep'
    out  = eval_tep(xk,[],[],model,false);
  case 'iota'
    out  = eval_iota(xk,gk,vk,model,false);
  case 'q'
    out  = 1./eval_iota(xk,gk,vk,model,false);
  case 'shear'
    out  = eval_shear(xk,gk,vk,model,false);
  case 'ti'
    out  = eval_ti(xk,gk,vk,model,false);
  case 'ne'
    out  = eval_ne(xk,gk,vk,model,false);
  case 'nep'
    out  = eval_nep(xk,gk,vk,model,false);
  case 'ni'
    out  = eval_ni(xk,gk,vk,model,false);
  case 'ze'
    out  = eval_ze(xk,gk,vk,model,false,false);
  case 'p'
    out.p =  eval_press(xk,gk,vk,model,false);
  case 'upl'
    out  = eval_psi(xkdot,gk,vk,model,false);
  case 'Ipl'
    out  = eval_Ipl(xk,gk,vk,model,false);
  case 'jpar'
    out = eval_jdotB(xk,gk,vk,model,false);
  case 'Wpol'
    out  = eval_Wpol(xk,gk,vk,model,false);
  case 'li3'
    % normalized internal inductance per unit length
    % (ITER definition, e.g. Jackson NF2008)
    li3prof = eval_li3(xk,gk,vk,model);
    out  = li3prof(end);
  case 'beta'
    % beta etc
    out  = eval_beta(xk,gk,vk,model);
  case 'betaN'
    out  = eval_betaN(xk,gk,vk,model);
  case 'signeo'
    out  = src.signeo;
  case 'jbs'
    out  = src.jbsB;
  case 'chie'
    out = src.chie;
  otherwise
    error('undefined RAPTOR output requested')
end

return