function sawteeth = RAPTOR_idsfill_sawteeth(out,model,code)

%% ----------------------
%% FILL THE SAWTEETH IDS
%% ----------------------

%% Generation
sawteeth=ids_gen('sawteeth');

%% IDS properties
sawteeth.ids_properties.comment = 'IDS generated from RAPTOR output';
sawteeth.ids_properties.homogeneous_time = 1;

%% Time vector
sawteeth.time = out.time;

%% General code information
sawteeth.code.name = code.name;
sawteeth.code.version = code.version;
sawteeth.code.parameters = code.parameters;
sawteeth.code.output_flag = 0;

%% Vacuum toroidal field
for itime=1:out.ntime
  sawteeth.vacuum_toroidal_field{itime}.b0 = out.B0(itime); % same as in RAPTOR_idsfill_core_profiles.m
end
sawteeth.vacuum_toroidal_field.r0 = model.equi.R0;

%% Time when sawteeth occur + sawtooth periods

%% -- TEMPORARY -- ====>  store the sawteeth time and period in other inappropriate variables of the IDS

%% Time-dependent vector (flag = 1 when sawtooth occurs)
sawteeth.diagnostics.rho_tor_norm_mixing = out.ST;

%% Time-dependent vector for sawtooth period.
sawteeth.rho_tor_norm_inversion = zeros(size(out.ST));
sawteeth.rho_tor_norm_inversion(find(out.ST==1)) = out.STper;

