function distributions = RAPTOR_idsfill_distributions(out,code)

%% ---------------------------
%% FILL THE DISTRIBUTIONS IDS
%% ---------------------------

%% ORDER: EC, IC, NB, LH, ALPHA
nsource = 5;

%% Generation
distributions = ids_gen('distributions');
for isource=2:nsource
  distributions.distribution{isource} = distributions.distribution{1};
end

%% IDS properties
distributions.ids_properties.comment = 'IDS generated from RAPTOR output';
distributions.ids_properties.homogeneous_time = 1;

%% Time vector
distributions.time = out.time;

%% General code information
distributions.code.name = code.name;
distributions.code.version = code.version;
distributions.code.parameters = code.parameters;
distributions.code.output_flag = 0;

%% Power and current
empty = zeros(size(out.Pec));
for itime=1:out.ntime
  distributions.distribution{1}.global_quantities{itime}.source{1}.power = out.Pec(itime);
  distributions.distribution{2}.global_quantities{itime}.source{1}.power = out.Pice(itime)+out.Pici(itime);
  distributions.distribution{3}.global_quantities{itime}.source{1}.power = out.Pnbe(itime)+out.Pnbi(itime);
  distributions.distribution{4}.global_quantities{itime}.source{1}.power = out.PLH(itime);
  distributions.distribution{5}.global_quantities{itime}.source{1}.power = out.Palpha(itime);

  distributions.distribution{1}.profiles_1d{itime}.collisions.electrons.power_thermal = out.pec(:,itime);
  distributions.distribution{2}.profiles_1d{itime}.collisions.electrons.power_thermal = out.pice(:,itime);
  distributions.distribution{3}.profiles_1d{itime}.collisions.electrons.power_thermal = out.pnbe(:,itime);
  distributions.distribution{4}.profiles_1d{itime}.collisions.electrons.power_thermal = out.plh(:,itime);
  distributions.distribution{5}.profiles_1d{itime}.collisions.electrons.power_thermal = out.palphae(:,itime);

  distributions.distribution{1}.profiles_1d{itime}.collisions.ions.power_thermal = empty(:,itime);
  distributions.distribution{2}.profiles_1d{itime}.collisions.ions.power_thermal = empty(:,itime);
  distributions.distribution{3}.profiles_1d{itime}.collisions.ions.power_thermal = empty(:,itime);
  distributions.distribution{4}.profiles_1d{itime}.collisions.ions.power_thermal = empty(:,itime);
  distributions.distribution{5}.profiles_1d{itime}.collisions.ions.power_thermal = out.palphai(:,itime);

  distributions.distribution{1}.profiles_1d{itime}.current_tor = out.jec(:,itime);
  distributions.distribution{2}.profiles_1d{itime}.current_tor = out.jic(:,itime);
  distributions.distribution{3}.profiles_1d{itime}.current_tor = out.jnb(:,itime);
  distributions.distribution{4}.profiles_1d{itime}.current_tor = out.jlh(:,itime);
  distributions.distribution{5}.profiles_1d{itime}.current_tor = empty(:,itime);

end

% distribution(:)/global_quantities(:)
% distribution(:)/profiles_1d(:)
% distribution(:)/profiles_2d(:)
% distribution(:)/ggd(:)
% distribution(:)/markers(:)
% vacuum_toroidal_field/b0
% magnetic_axis/r
% magnetic_axis/z
% code/output_flag

