function core_transport = RAPTOR_idsfill_core_transport(out,model,code)

%% ---------------------------
%% FILL THE CORE_TRANSPORT IDS
%% ---------------------------

%% Generation
core_transport = ids_gen('core_transport');

%% IDS properties
core_transport.ids_properties.comment = 'IDS generated from RAPTOR output';
core_transport.ids_properties.homogeneous_time = 1;

%% Time vector
core_transport.time = out.time;

%% General code information
core_transport.code.name = code.name;
core_transport.code.version = code.version;
core_transport.code.parameters = code.parameters;
core_transport.code.output_flag = 0;

%% 1D-profiles
for itime=1:out.ntime
  core_transport.profiles_1d{1}.grid.rho_tor_norm         = out.rho(:);
  core_transport.profiles_1d{1}.grid.psi                  = out.psiN(:,itime);
  core_transport.profiles_1d{1}.grid.volume               = out.Volume(:,itime);
  core_transport.profiles_1d{itime}.electrons.temperature = out.te(:,itime);
  core_transport.profiles_1d{itime}.electrons.density     = out.ne(:,itime);
  core_transport.profiles_1d{itime}.ions.temperature      = out.ti(:,itime);
  core_transport.profiles_1d{itime}.ions.density          = out.ni(:,itime);
  core_transport.profiles_1d{itime}.q                     = out.q(:,itime);
  core_transport.profiles_1d{itime}.magnetic_shear        = out.shear(:,itime);
  core_transport.profiles_1d{itime}.j_tor                 = out.jtor(:,itime);
  core_transport.profiles_1d{itime}.j_bootstrap           = out.jbs(:,itime);
  core_transport.profiles_1d{itime}.j_ohmic               = out.joh(:,itime);
  core_transport.profiles_1d{itime}.zeff                  = out.ze(:,itime);
  core_transport.profiles_1d{itime}.j_total               = out.jaux(:,itime)+out.jbs(:,itime)+out.joh(:,itime);
  core_transport.profiles_1d{itime}.j_non_inductive       = out.jaux(:,itime)+out.jbs(:,itime);
  core_transport.profiles_1d{itime}.pressure_thermal      = out.p(:,itime);
  core_transport.profiles_1d{itime}.conductivity_parallel = out.signeo(:,itime);
end

