function core_profiles = RAPTOR_idsfill_core_profiles(out,model,code)

%% Extra stuff that is needed that RAPTOR does not calculate
rhotorm = bsxfun(@times,out.rho,sqrt(out.Phib./pi./out.B0)); % rhotor in meters

%% ---------------------------
%% FILL THE CORE_PROFILES IDS
%% ---------------------------

%% GENERATION
% core_profiles = ids_gen('core_profiles');
core_profiles = ids_init('core_profiles');
core_profiles.profiles_1d = ids_allocate('core_profiles','profiles_1d',out.ntime);

%% IDS PROPERTIES
core_profiles.ids_properties.comment = 'IDS generated from RAPTOR output';
core_profiles.ids_properties.homogeneous_time = 1;

%% TIME VECTOR (S)
core_profiles.time = out.time;

%% GENERAL CODE INFORMATION
%core_profiles.code.commit      = 
core_profiles.code.name        = code.name;
core_profiles.code.output_flag = 0;
core_profiles.code.parameters  = code.parameters;
%core_profiles.code.repository  = 
core_profiles.code.version     = code.version;

%% VACUUM TOROIDAL FIELD
core_profiles.vacuum_toroidal_field.r0 = model.equi.R0;
core_profiles.vacuum_toroidal_field.b0 = out.B0;

%% 1D-PROFILES: ON COMMON GRID BUT LESS ACCURATE THAN "GAUSS" VARIABLES
%% (ON "GAUSS" SPECIFIC GRID, MORE ACCURATE BUT INCOMPLETE => NOT USED HERE)
for itime=1:out.ntime

% $$$   core_profiles.profiles_1d{itime}.e_field =
% $$$   core_profiles.profiles_1d{itime}.e_field_parallel =
% $$$   core_profiles.profiles_1d{itime}.j_bootstrap =
% $$$   core_profiles.profiles_1d{itime}.j_non_inductive =
% $$$   core_profiles.profiles_1d{itime}.j_ohmic =
% $$$   core_profiles.profiles_1d{itime}.j_tor =
% $$$   core_profiles.profiles_1d{itime}.j_total =
% $$$   core_profiles.profiles_1d{itime}.magnetic_shear =
% $$$   core_profiles.profiles_1d{itime}.momentum_tor =
% $$$   core_profiles.profiles_1d{itime}.n_i_total_over_n_e =
% $$$   core_profiles.profiles_1d{itime}.neutral =
% $$$   core_profiles.profiles_1d{itime}.pressure_ion_total =
% $$$   core_profiles.profiles_1d{itime}.pressure_parallel =
% $$$   core_profiles.profiles_1d{itime}.pressure_perpendicular =
% $$$   core_profiles.profiles_1d{itime}.pressure_thermal =
% $$$   core_profiles.profiles_1d{itime}.q =
% $$$   core_profiles.profiles_1d{itime}.time =
% $$$   core_profiles.profiles_1d{itime}.zeff =
% $$$ 
% $$$   core_profiles.profiles_1d{itime}.electrons.density_fast = 
% $$$   core_profiles.profiles_1d{itime}.electrons.pressure = 
% $$$   core_profiles.profiles_1d{itime}.electrons.pressure_fast_perpendicular  = 
% $$$   core_profiles.profiles_1d{itime}.electrons.pressure_fast_parallel =
% $$$   core_profiles.profiles_1d{itime}.electrons.velocity.parallel = 
% $$$   core_profiles.profiles_1d{itime}.electrons.velocity.diamagnetic = 
% $$$   core_profiles.profiles_1d{itime}.electrons.velocity.radial = 
% $$$   core_profiles.profiles_1d{itime}.electrons.velocity.toroidal = 
% $$$   core_profiles.profiles_1d{itime}.electrons.velocity.poloidal = 
% $$$     
% $$$   core_profiles.profiles_1d{itime}.ion{1}.density_fast =
% $$$   core_profiles.profiles_1d{itime}.ion{1}.element =
% $$$   core_profiles.profiles_1d{itime}.ion{1}.label =
% $$$   core_profiles.profiles_1d{itime}.ion{1}.multiple_states_flag =
% $$$   core_profiles.profiles_1d{itime}.ion{1}.neutral_index =
% $$$   core_profiles.profiles_1d{itime}.ion{1}.pressure =
% $$$   core_profiles.profiles_1d{itime}.ion{1}.pressure_fast_parallel =
% $$$   core_profiles.profiles_1d{itime}.ion{1}.pressure_fast_perpendicular =
% $$$   core_profiles.profiles_1d{itime}.ion{1}.state =
% $$$   core_profiles.profiles_1d{itime}.ion{1}.velocity =
% $$$   core_profiles.profiles_1d{itime}.ion{1}.velocity_pol =
% $$$   core_profiles.profiles_1d{itime}.ion{1}.velocity_tor =
% $$$   core_profiles.profiles_1d{itime}.ion{1}.z_ion =
% $$$   core_profiles.profiles_1d{itime}.ion{1}.z_ion_1d =
% $$$   core_profiles.profiles_1d{itime}.ion{1}.z_ion_square_1d =
% $$$   core_profiles.profiles_1d{itime}.ion{1}.element.a =
% $$$   core_profiles.profiles_1d{itime}.ion{1}.element.multiplicity =
% $$$   core_profiles.profiles_1d{itime}.ion{1}.element.z_n =
% $$$   core_profiles.profiles_1d{itime}.ion{1}.state.density =
% $$$   core_profiles.profiles_1d{itime}.ion{1}.state.density_fast =
% $$$   core_profiles.profiles_1d{itime}.ion{1}.state.electron_configuration =
% $$$   core_profiles.profiles_1d{itime}.ion{1}.state.ionisation_potential =
% $$$   core_profiles.profiles_1d{itime}.ion{1}.state.is_neutral =
% $$$   core_profiles.profiles_1d{itime}.ion{1}.state.label =
% $$$   core_profiles.profiles_1d{itime}.ion{1}.state.neutral_type =
% $$$   core_profiles.profiles_1d{itime}.ion{1}.state.pressure =
% $$$   core_profiles.profiles_1d{itime}.ion{1}.state.pressure_fast_parallel =
% $$$   core_profiles.profiles_1d{itime}.ion{1}.state.pressure_fast_perpendicular =
% $$$   core_profiles.profiles_1d{itime}.ion{1}.state.temperature =
% $$$   core_profiles.profiles_1d{itime}.ion{1}.state.velocity =
% $$$   core_profiles.profiles_1d{itime}.ion{1}.state.vibrational_level =
% $$$   core_profiles.profiles_1d{itime}.ion{1}.state.vibrational_mode =
% $$$   core_profiles.profiles_1d{itime}.ion{1}.state.z_average =
% $$$   core_profiles.profiles_1d{itime}.ion{1}.state.z_max =
% $$$   core_profiles.profiles_1d{itime}.ion{1}.state.z_min =
% $$$   core_profiles.profiles_1d{itime}.ion{1}.state.z_square_average =
  
  core_profiles.profiles_1d{itime}.grid.psi          = out.psi(:,itime);
  core_profiles.profiles_1d{itime}.grid.rho_tor      = rhotorm(:,itime);
  core_profiles.profiles_1d{itime}.grid.rho_tor_norm = out.rho(:);
  core_profiles.profiles_1d{itime}.grid.volume       = out.Volume(:,itime);

  core_profiles.profiles_1d{itime}.electrons.temperature = out.te(:,itime);
  core_profiles.profiles_1d{itime}.electrons.density     = out.ne(:,itime);
  core_profiles.profiles_1d{itime}.t_i_average           = out.ti(:,itime);
  % core_profiles.profiles_1d{itime}.ion{1}.temperature    = out.ti(:,itime);
  % core_profiles.profiles_1d{itime}.ion{1}.density        = out.ni(:,itime);
  core_profiles.profiles_1d{itime}.q                     = out.q(:,itime);
  core_profiles.profiles_1d{itime}.magnetic_shear        = out.shear(:,itime);
  core_profiles.profiles_1d{itime}.j_tor                 = out.jtor(:,itime);
  core_profiles.profiles_1d{itime}.j_bootstrap           = out.jbs(:,itime);
  core_profiles.profiles_1d{itime}.j_ohmic               = out.joh(:,itime);
  core_profiles.profiles_1d{itime}.zeff                  = out.ze(:,itime);
  core_profiles.profiles_1d{itime}.j_total               = out.jpar(:,itime);
  core_profiles.profiles_1d{itime}.j_non_inductive       = out.jaux(:,itime)+out.jbs(:,itime);
  core_profiles.profiles_1d{itime}.pressure_thermal      = out.p(:,itime);
  core_profiles.profiles_1d{itime}.conductivity_parallel = out.signeo(:,itime);
end

%% GLOBAL QUANTITIES
%core_profiles.global_quantities.beta_pol(itime) =
%core_profiles.global_quantities.beta_tor(itime) = 
%core_profiles.global_quantities.beta_tor_norm(itime) = 
%core_profiles.global_quantities.current_bootstrap(itime) = 
%core_profiles.global_quantities.current_non_inductive(itime) = 
%core_profiles.global_quantities.energy_diamagnetic(itime) = 
%core_profiles.global_quantities.ip(itime) = 
%core_profiles.global_quantities.li(itime) = 
%core_profiles.global_quantities.li_3(itime) = 
%core_profiles.global_quantities.v_loop(itime) = 

