n=31;

T = eye(n);
rgrid = linspace(0,1,n);

pargrid = [
    1e-6 1 1
    1e-6 5 1
    1e-6 1 5
    1e-1 1 1
    1e-1 1 5
    1e0 5 1];

hf = figure(1); clf(hf);
hax = multiaxes(hf,3,2,[],[],[0.05 0.15]);

%%
for ii=1:size(pargrid,1);
    sm = pargrid(ii,1);
    cov_0 = pargrid(ii,2);
    cov_e = pargrid(ii,3);
    
    SS = gencov(sm,cov_0,cov_e,rgrid,T);
    ax = hax(ii);
    hp = imagesc(rgrid,rgrid,SS,'parent',ax);
    axis(ax,'equal','tight');
    colorbar(ax);
    xlabel(ax,'\rho_N');
    ylabel(ax,'\rho_N');
    title(ax,sprintf('c_s=%1.0g, c_0 = %1.0f, c_b = %1.0f',pargrid(ii,:)));
end
    
set(hf,'position',[50 50 800 400]);
set(gcf,'paperpositionmode','auto');
print('-depsc','gencov_examples','-loose');

