function SS = gencov(sm,cov_0,cov_e,cov_rhopow,cov_usegauss,cov_gauss_width,rgrid,T,varargin)
% function SS = gencov(sm,cov_0,cov_e,rgrid,T,varargin)
% generates covariance matrix representing smooth profiles

rhoped = 1;
if ~isempty(varargin)
  rhoped = varargin{1};
end  
  
smr = exp(-rgrid.^2/sm.^2); % smoothing vs rho
if cov_usegauss
  gauss_shape=exp(-(rgrid.^2)./(cov_gauss_width^2)).*(1-(rgrid./rhoped).^2); % gauss + force edge to zero withh power scal
  lco = sqrt(cov_e) + (sqrt(cov_0)-sqrt(cov_e))*gauss_shape;
else
  lco = sqrt(cov_e) + (sqrt(cov_0)-sqrt(cov_e))*(1-(rgrid./rhoped).^cov_rhopow); % lower covariance close to edge
end
ST = diag(lco)*toeplitz(smr)*diag(lco); % Covariance matrix after transformation

% extra constraint for psi_e, special case, disabled for now
% if ~isempty(varargin)
%   cov_psi_edge = varargin{1};
%   ST = blkdiag(STo,cov_psi_edge);
% else
%   ST = STo;
% end

pT = pinv(T);
SS = pT*ST*pT';

return