function [a, f] = eval_param_sel(params, field_tree)
% support function for parameter estimation
% f: cell array with field names in field_tree 
% a: content of structure at field specified in field_tree
a = params;
dotloc =  strfind(field_tree,'.');
dotloc(end+1) = numel(field_tree)+1;
firstchar = 1;
f = cell(1, numel(dotloc));
for ii = 1:numel(dotloc)
  fldname = field_tree(firstchar:dotloc(ii)-1);
  s = extractfield(a,fldname);
  f{ii} =  fldname;
  if ~iscell(s); a = s; break; end
  a = s{1};
  firstchar = dotloc(ii)+1;
end
end