function [smoothres, simres_smoother] = RAPTOR_RTSsmoother(obsres, simres, model, KFmodel, KFparams)
% Fixed-interval smoothing algorithm based on Anderson (1979) Sec 7.7
% Implementation based on eq. 4.5-4.7
% Starts from output of EKF filter (including Sk_k and Sk_km1 matrices, all stored in obsres)
% So, first run [obsres,simres] = RAPTOR_EKF_sim(G,V,U,H,model,params,KFmodel,KFparams)
% Then, the present smoother can be run, which will to a backward sweep to propagate meaurement information backwards in time
% xk_M stands for estimate at time t(k) given all measurements from time t(1) to t(end)

itend = size(obsres.Zk_k,2);
Zk_M = zeros(size(obsres.Zk_k));
Zk_M(:,itend) = obsres.Zk_k(:,itend);
diagfun = model.diagnostics.diagfun;
Hk_M = zeros(size(obsres.Hk_k));
Hk_M(:,itend) = diagfun(Zk_M(KFmodel.ix,itend), simres.G(:,itend), simres.V(:,itend), simres.U(:,itend), itend, model);
Sk_Mmat = zeros(size(obsres.Sk_kmat));
Sk_Mmat(:,:,itend) = obsres.Sk_kmat(:,:,itend);
for ii = 1:itend-1
  jm1 = itend-ii;
  Zk_M(:,jm1) = obsres.Zk_k(:,jm1) + obsres.Sk_kmat(:,:,jm1)*obsres.Fkmat(:,:,jm1)'/obsres.Sk_km1mat(:,:,jm1+1)* ...
    (Zk_M(:,jm1+1) - obsres.Zk_km1(:,jm1+1));
  Hk_M(:,jm1) = diagfun(Zk_M(KFmodel.ix,jm1), simres.G(:,jm1), simres.V(:,jm1), simres.U(:,jm1), jm1, model);
  Lambda = obsres.Sk_kmat(:,:,jm1)*obsres.Fkmat(:,:,jm1)'/obsres.Sk_km1mat(:,:,jm1+1);
  Sk_Mmat(:,:,jm1) = obsres.Sk_kmat(:,:,jm1) + Lambda * (Sk_Mmat(:,:,jm1+1) - obsres.Sk_km1mat(:,:,jm1+1)) * Lambda';
  if KFparams.verbose>0; RTSdisp(ii,jm1, norm(Zk_M(KFmodel.ix,jm1) - obsres.Xk_k(:,jm1))./norm(obsres.Xk_k(:,jm1))); end
end
smoothres.Zsmo = Zk_M;
smoothres.Xsmo = Zk_M(KFmodel.ix, :);
smoothres.Dsmo = Zk_M(KFmodel.id, :);
smoothres.Psmo = Zk_M(KFmodel.ip, :);
smoothres.Sk_Mmat = Sk_Mmat;
smoothres.Hk_M = Hk_M;

simres_smoother = simres;
simres_smoother.X = Zk_M(KFmodel.ix, :);
end

function RTSdisp(ii,jm1, reldiff)
if ~mod(ii-1,20)
  fprintf('\n%5s%5s%9s\n','it','jm1','|upd|/|zk|')
end
fprintf('%5d%5d%9.2e\n',ii, jm1, reldiff)
end