function [zk_k, zk_km1, xdotk, hk_km1, ...
          Sk_k, Sk_km1, Omk, Lk, Fk, Gk, Hk, Rk, ...
          stapk, geopk, trapk, res, icrash, i_act_chann, exitflag, TS_out] = ...
  RAPTOR_EKF_step(zkm1_km1, xdotkm1, mk, ...
  gk, gdotk, vk, vdotk, uk, Skm1_km1, Qk, dtk, it, RAPTORmodel, RAPTORparams, KFmodel, KFparams, stapkm1, geopkm1, trapkm1, varargin)
%#codegen
% Roughly follows notation of Anderson (1979) Ch. 8

if ~isempty(varargin)
  LYk = varargin{1};
end

if isempty(stapkm1)
  stapkm1 = init_stap(RAPTORmodel);
end
if isempty(geopkm1)
  geopkm1=init_geop(RAPTORmodel);
end
if isempty(trapkm1)
  trapkm1=init_trap(RAPTORmodel);
end

coder.extrinsic('KFplot');
coder.extrinsic('KFdisp');
coder.extrinsic('RAPTOR_plot_step');
coder.extrinsic('RAPTOR_out');
coder.extrinsic('warning');

% checks for some sizes
assert(KFmodel.nz<200);
assert(KFmodel.nx<200);
assert(KFmodel.nu<50);
assert(KFmodel.nd<200);

icrash = 0;
ny = numel(mk);
nz = KFmodel.nz;
% assert(ny<200);

%% State update
xkm1_km1 = zkm1_km1(KFmodel.ix); % get RAPTOR model state
dkm1 = zkm1_km1(KFmodel.id); % disturbance
pkm1 = zkm1_km1(KFmodel.ip); % for parameter estimation

% init
if it==1
  stapkm1 = state_profiles(xkm1_km1,xdotkm1,gk,gdotk,vk,vdotk,RAPTORmodel,stapkm1);
  geopkm1 = geometry_profiles(gk,gdotk,RAPTORmodel,geopkm1);
  trapkm1 = transport_profiles(stapkm1,stapkm1,geopkm1,dkm1,uk,it,RAPTORmodel,RAPTORparams,0,trapkm1);
end

% set estimated parameters equal to estimate from previous time step
% (anyway p(k|k-1)=p(k-1|k-1)) = pkm1)
param_estim = false;
if KFmodel.npx>0
  for ii = 1:KFmodel.npx
    [~, f] = eval_param_sel(RAPTORparams, KFparams.param_sel{ii});
    RAPTORparams.(f{1}).(f{2}) = pkm1(ii);
  end
  param_estim = true;
end

% nonlinear predictive step - one step simulation of physics
[xk_km1, xdotk, ~, ~, dftilde_dxk, dftilde_dxkm1, ~, dftilde_dd, dftilde_dw, ~,...
  ~, geopk, ~, res, inewt, exitflag] = ...
  RAPTOR_predictive_step(it, dtk, xkm1_km1, xdotkm1, gk, gdotk, vk, vdotk, uk, dkm1, ...
  stapkm1, geopkm1, trapkm1, RAPTORmodel, RAPTORparams);

if it==1
  xk_km1(RAPTORmodel.psi.xind) = xk_km1(RAPTORmodel.psi.xind)-xk_km1(RAPTORmodel.psi.xind(end)); % use gauge freedom to have psie(t0)=0
end

dk_km1 = dkm1; % trivial disturbance prediction step

pk_km1 = pkm1; % trivial estimated parameter prediction step

%% Linearization
if KFparams.noise_model
  [Fk, Gk] = calc_linearization(dftilde_dxk, dftilde_dxkm1, dftilde_dd, dftilde_dw, KFmodel);
else
  Fk = calc_linearization(dftilde_dxk, dftilde_dxkm1, dftilde_dd, dftilde_dw, KFmodel);
  Gk = eye(nz);
  % process noise acts directly on state
  % xk = fk(xkm1,uk) + Gk*wk with Gk = I
end
if param_estim
  Fk = blkdiag(Fk, eye(KFmodel.npx)); % dpk_dpkm1 = 1
  eps=1e-3;
  for ii = 1:KFmodel.npx
    % for now jacobians dxk_dpk through finite differences
    [~, f] = eval_param_sel(RAPTORparams, KFparams.param_sel{ii});
    RAPTORparams_pert = RAPTORparams;
    RAPTORparams_pert.(f{1}).(f{2}) = pkm1(ii)+eps;
    xk_km1_pert = RAPTOR_predictive_step(it, dtk, xkm1_km1, xdotkm1, gk, gdotk, vk, vdotk, uk, dkm1, ...
                  stapkm1, geopkm1, trapkm1, RAPTORmodel, RAPTORparams_pert);
    dx_dp = (xk_km1_pert - xk_km1)/eps;   
    Fk(KFmodel.ix, KFmodel.ip(ii)) = dx_dp;
  end
end
%% Covariance matrix time step update
% with extra alpha parameter for lower weighting of past measurements
% (cf. Anderson(1979), Ch6.2)
Sk_km1 = KFparams.alpha.^2*Fk(1:nz,1:nz)*Skm1_km1(1:nz,1:nz)*Fk(1:nz,1:nz)' ...
         + Gk*Qk*Gk';

if state_ok(exitflag) && strcmp(RAPTORmodel.saw,'porcelli')
    % possible MHD
    % only if porcelli ST model selected, else no MHD
    [xk_mhd,icrash] = RAPTOR_mhd(xk_km1,gk,vk,uk,it,RAPTORmodel,RAPTORparams);
    mhd_exitflag = check_state_validity(xk_mhd,gk,vk,RAPTORmodel);
    % Recover if things go wrong
    if mhd_exitflag ~= -1
      exitflag = mhd_exitflag; % update exitflag
    else
      % update xk_km1 with post-MHD state
      xk_km1 = xk_mhd;
    end
end

%% Measurement updates

% synthetic diagnostics
if RAPTORmodel.equi.eq_call
  diagfun = RAPTORmodel.diagnostics.diagfun;
  if KFparams.TS_diag_act
    [hk_km1, dhk_dx, ~, Rk, ~, ~, i_act_chann, rho_tor_TS] = diagfun(xk_km1, gk, vk, uk, it, LYk);
    TS_out.rho_tor_TS = rho_tor_TS;
  else
    [hk_km1, dhk_dx, ~, Rk, ~, ~, i_act_chann] = diagfun(xk_km1, gk, vk, uk, it, LYk);
    TS_out = [];
  end
else
  diagfun = RAPTORmodel.diagnostics.diagfun;
  [hk_km1, dhk_dx, ~, Rk, ~, ~] = diagfun(xk_km1, gk, vk, uk, it, RAPTORmodel);
  i_act_chann = true(KFmodel.ny, 1);
  TS_out = [];
end
Hk = [dhk_dx, zeros(numel(hk_km1), KFmodel.nd+KFmodel.npx)];

%% Fallback if needed
if state_ok(exitflag) && ~isnan(res)
  zk_km1 = [xk_km1; dk_km1; pk_km1];
else
  % Backup option in case things go wrong.
  % Restart everything from previous step, deflating disturbance
  warning('Fallback EKF step triggered')
  
  nyact = sum(i_act_chann);
  
  zk_km1 = zkm1_km1;
  zk_k = zkm1_km1; % previous state
  zk_k(KFmodel.id) = 0.5 * zk_k(KFmodel.id); % decrease disturbance
  
  Sk_km1 = Skm1_km1;  Sk_k = Skm1_km1;
  
  [Omk,Lk,Fk,Gk,xdotk,res] = default_fallback(KFmodel, ny, nyact);
  if ~KFparams.noise_model
    Gk = zeros(KFmodel.nz,KFmodel.nz);
  end
  
  stapk = stapkm1;
  geopk = geopkm1;
  trapk = trapkm1;
  
  return
end

%% Kalman gain

Omk = Hk(i_act_chann,:)*Sk_km1*Hk(i_act_chann,:)' + Rk(i_act_chann,i_act_chann); % innovation covariance
Lk = (Sk_km1*Hk(i_act_chann,:)')/Omk; % right inverse

% state measurement update
upd = Lk*(mk(i_act_chann)-hk_km1(i_act_chann)); 
if numel(KFparams.Lgain)>1
  Lgain = KFparams.Lgain(it);
else
  Lgain = KFparams.Lgain;
end

zk_k = zk_km1 + Lgain*upd; % extra scalar to control update (usually =1)

% physics sanity check (e.g. avoid neg Te ...)
% clamp temperatures under 10eV
telowlim = 50/RAPTORmodel.te.scal;
tehatind_viol = zk_k(KFmodel.ix(RAPTORmodel.te.xind))<telowlim;
zk_k(KFmodel.ix(RAPTORmodel.te.xind(tehatind_viol))) = telowlim;

% xdotk = (zk_k(KFmodel.ix) - xkm1_km1)/dtk;

if KFparams.debug_plot
  
  figure;errorbar(1:numel(mk(i_act_chann)), mk(i_act_chann), sqrt(diag(Rk(i_act_chann,i_act_chann))));
  hold on
  plot(hk_km1(i_act_chann)); hold on;plot(Hk(i_act_chann,:)*zk_k)
  xlabel('active channels'); title('Te [keV]'); legend('meas','k|k-1','k|k')

  figure;plot(zk_km1);hold on; plot(zk_k)
  xlabel('spline coeff'); ylabel('spline amp'); legend('k|k-1','k|k')

  keyboard()
%   figure;plot(rho_tor_TS(i_act_chann), mk(i_act_chann),'x', rho_tor_TS(i_act_chann), hk_km1(i_act_chann),'.', ...
%     rho_tor_TS(i_act_chann), Hk(i_act_chann,:)*zk_k,'+')
%   xlabel('active channels'); title('Te [keV]'); legend('meas','k|k-1','k|k')
  
end

pk_k = zk_k(KFmodel.ip);
if param_estim
  for ii = 1:KFmodel.npx
    if pk_k(ii)<KFparams.param_min(ii); pk_k(ii)=KFparams.param_min(ii); end
  end
  zk_k(KFmodel.ip) = pk_k;
  if KFparams.verbose>0; fprintf('estimated parameter(s):\n'); disp(pk_k); end
end

xk_k = zk_k(KFmodel.ix);

dk_k = zk_k(KFmodel.id);

stapk = state_profiles(xk_k,xdotk,gk,gdotk,vk,vdotk,RAPTORmodel,stapkm1);
trapk = transport_profiles(stapkm1,stapk,geopk,dk_k,uk,it,RAPTORmodel,RAPTORparams,inewt,trapkm1);

% Check whether this state is unphysical
if check_state_validity(zk_k(KFmodel.ix),gk,vk,RAPTORmodel) ~= -1
  % ignore measurement update
  zk_k = zk_km1;
end

% Covariance matrix measurement update
Sk_k = (eye(KFmodel.nz) - Lk*Hk(i_act_chann,:))*Sk_km1;

%% Plots etc
if KFparams.iterdisp && (rem(it,double(KFparams.iterdisp))==0) && KFparams.verbose>0
  fracnorm = norm(upd(KFmodel.ix))/norm(zkm1_km1(KFmodel.ix)); % relative norm of state update
  KFdisp(it,inewt,res,exitflag,fracnorm,KFparams);
end

end

function KFdisp(it,inewt,res,exitflag,updn,KFparams)

if ~mod(it-1,KFparams.iterdisp*20)
  fprintf('\n%5s%5s%9s%9s%10s\n','it','inewt','res','|upd|/|xk|','exitflag')
end
fprintf('%5d%5d%9.2e%9.2e%10d\n',[it,inewt,res,updn,exitflag])

end

function [Omk,Lk,Fk,Gk,xdotk,res] = default_fallback(KFmodel,ny,nyact)
Omk    = zeros(nyact);
Lk     = zeros(KFmodel.nz, ny);
Fk     = eye(KFmodel.nz);
Gk     = zeros(KFmodel.nz,KFmodel.nw);

xdotk = zeros(KFmodel.nx,1); % set to 0
res = 0;
end

function [Fk,Gk] = calc_linearization(dftilde_dxk,dftilde_dxkm1,...
  dftilde_dd,dftilde_dw,KFmodel)
%% Linearized state equation matrices
dfxkinv  =   dftilde_dxk\eye(KFmodel.nx);
AA       = - dfxkinv * dftilde_dxkm1;
Bxd      = - dfxkinv * dftilde_dd;
Bxw      = - dfxkinv * dftilde_dw; % noise model

Odx = zeros(KFmodel.nd,KFmodel.nx); % zeros matrix
Id = eye(KFmodel.nd,KFmodel.nd); % identity

Fk = [AA, Bxd; Odx, Id];
Gk = blkdiag(Bxw,Id); % Gkw

% xk = A*xkm1 + Bxd*dkm1 + Bxu * uk + Bxw*wxk
% dk = 0*xkm1 +  I *dkm1 +   0 * uk +  Id*wdk
%
% zk = [xk;dk];
% zk = Fk*zkm1 + Gku*uk + Gkw*wk + s
end

function statok = state_ok(exitflag)
statok = any(exitflag == [0 1]);
end