function  [obsres,simres] = RAPTOR_EKF_sim(Gin,V,U,H,model,params,KFmodel,KFparams)

% initial plasma state derivative (for solver)

if isa(KFparams,'Simulink.Parameter')
    KFp = KFparams.Value;
else
    KFp = KFparams;
end

zkm1_km1 = [KFp.xk_0; KFp.dk_0; KFp.pk_0]; % initial estimated state
xdotkm1 = initialize_xdot(model,params); % initialize xdot

nt = numel(params.tgrid);

ink = zeros(KFmodel.ny,nt);
% negative of the log-likelyhood function of the innovations
loglike_ink = zeros(1,nt);
res = zeros(1,nt);
exitflag = zeros(1,nt);

Hk_km1 = zeros(KFmodel.ny,nt);
Hk_k   = zeros(KFmodel.ny,nt);
Mk_act_channel = false(KFmodel.ny,nt); % flag for active measurements
if KFparams.TS_diag_act
  RHO_tor_TS = zeros(KFmodel.TS_model.n_TS,nt); % rho coordinate for TS measurements
end
Xk_k   = zeros(KFmodel.nx,nt); % state estimate
Xk_km1 = zeros(KFmodel.nx,nt);
Zk_k   = zeros(KFmodel.nz,nt);
Zk_km1 = zeros(KFmodel.nz,nt);
Xdotk  = zeros(KFmodel.nx,nt);
Dk_k   = zeros(KFmodel.nd,nt);
Pk_k   = zeros(KFmodel.npx,nt);
Sk_kmat= zeros(KFmodel.nz,KFmodel.nz,nt);
Sk_ktrace = zeros(1,nt);
Sk_km1mat= zeros(KFmodel.nz,KFmodel.nz,nt);
Rkmat  = zeros(KFmodel.ny,KFmodel.ny,nt);

Fkmat  = zeros(KFmodel.nz,KFmodel.nz,nt);
if KFparams.noise_model
  Gkmat= zeros(KFmodel.nz,KFmodel.nw,nt);
else
  Gkmat= zeros(KFmodel.nz,KFmodel.nz,nt);
end
Hkmat  = zeros(KFmodel.ny,KFmodel.nz,nt);
% Lkmat  = zeros(KFmodel.nz,KFmodel.ny,nt);
Lks = cell(1,nt); % cell array since nr of measurements can vary
Omks = cell(1,nt);

% srcs   = cell(nt,1);

traps = cell(1,nt);
staps = cell(1,nt);
geops = cell(1,nt);
subiter_info  = cell(1,nt);

for it = 1:nt
    vk = V(:,it); % kinetic profiles
    uk = U(:,it); % actuator traces
	  hk = H(:,it); % measurements
    
    % state covariances
    if it==1
        [Qx,Qd,Sx0,Sd0] = KFcovariances_offline(KFmodel,KFp,model);
        Qp = diag(bsxfun(@times, KFp.param_std.^2, ones(1,KFmodel.npx)));
        Sp0 = diag(bsxfun(@times, KFp.s0p, ones(1,KFmodel.npx)));
        Qk = blkdiag(Qx,Qd,Qp);
        Skm1_km1 = blkdiag(Sx0,Sd0,Sp0);
        stapkm1 = []; geopkm1 = []; trapkm1 = [];
    end

    
    %%
    if it~=nt; dtk = params.tgrid(it+1)-params.tgrid(it);
    else; dtk = params.tgrid(it)-params.tgrid(it-1); end
    
    if it==1; vdotk = zeros(size(vk)); 
    else; vdotk = (V(:,it)-V(:,it-1))/dtk; end
    
    % Equilibrium update
    if it==1
      if model.equi.eq_call
        G = zeros(model.dims.ng, nt);
      else
        G = Gin;
      end
    end
    if model.equi.eq_call
      if it==1
        gkm1 = Gin(:,it);
      else
        gkm1 = G(:,it-1);
      end
      [gk, eqdata] = update_equilibrium(model, params, zkm1_km1(KFmodel.ix), gkm1, vk, 1, it);
      LYk = eqdata.data_out;
      if LYk.isconverged
        subiter_info{it}.eq_calls{1} = eqdata;
        G(:,it) = gk;
      else
        % fallback strategy: maintain last converged equilibrium
        subiter_info{it}.eq_calls{1} = subiter_info{it-1}.eq_calls{1};
        G(:,it) = G(:,it-1);
        LYk = subiter_info{it-1}.eq_calls{1}.data_out;
        gk = G(:,it);
        warning('LIUQE did not converge')
        % fallback strategy: run MER liuqe with reset flag
%         params.equi.splbf = false;
%         [gk, eqdata] = update_equilibrium(model, params, zkm1_km1(KFmodel.ix), gkm1, vk, 1, it, 1, LYk);
%         LYk = eqdata.data_out;
%         subiter_info{it}.eq_calls{1} = eqdata;
%         G(:,it) = gk;
%         params.equi.splbf = true;
      end
    else
      gk = G(:,it);
      LYk = [];
    end
    if it==1; gdotk = zeros(size(gk));
    else; gdotk = (G(:,it)-G(:,it-1))/dtk; end 
    
    [zk_k, zk_km1, xdotk, hk_km1, ...
    Sk_k, Sk_km1, Omk, Lk, Fk, Gk, Hk, Rk, ...
    stapk, geopk, trapk, res(it), ~, Mk_act_channel(:,it), exitflag(it), TS_out] = ...
    RAPTOR_EKF_step(zkm1_km1, xdotkm1, hk, ...
    gk, gdotk, vk, vdotk, uk, Skm1_km1, Qk, dtk, it, model, params, KFmodel, KFparams, stapkm1, geopkm1, trapkm1, LYk);
      
    i_act_chann = Mk_act_channel(:,it);
  
    if KFparams.TS_diag_act
      RHO_tor_TS(:,it) = TS_out.rho_tor_TS;
    end

    xk_k = zk_k(1:KFmodel.nx);
    xk_km1 = zk_km1(1:KFmodel.nx);
    dk_k = zk_k((KFmodel.nx+1):(KFmodel.nx+KFmodel.nd));
    pk_k = zk_k((KFmodel.nx+KFmodel.nd+1):(KFmodel.nx+KFmodel.nd+KFmodel.npx));
    
    if model.equi.eq_call
      diagfun = model.diagnostics.diagfun;
      hk_k = diagfun(xk_k, gk, vk, uk, it, LYk);
    else
      diagfun = model.diagnostics.diagfun;
      hk_k = diagfun(xk_k, gk, vk, uk, it, model);
    end
    
    % storage
    ink(i_act_chann,it) = hk(i_act_chann)-hk_km1(i_act_chann); % ink(:,it) = sqrt(Rkm1)\(hk-hk_km1); % innovation sequence
    Lks{it} = Lk;
    loglike_ink(:,it) = log(det(Omk)) + (hk(i_act_chann)-hk_km1(i_act_chann))'*pinv(Omk)*(hk(i_act_chann)-hk_km1(i_act_chann));
    %Ak = Hk*Fk*Sk_km1*Fk'*Hk';
    %Bk = Hk*Qk*Hk';
    %J1k(:,it) = trace(pinv(Ak+Bk+Rk)*Rk);
    %J2k(:,it) = trace(pinv(Ak+Bk)*Bk);

    Hk_km1(:,it)   = hk_km1;
    Hk_k(:,it)   = hk_k;
    Xk_k(:,it)   = xk_k; % state estimate
    Xk_km1(:,it) = xk_km1;
    Xdotk(:,it) = xdotk;
    
    staps{it} = stapk;
    geops{it} = geopk;
    traps{it} = trapk;

    Zk_k(:,it)      = zk_k;
    Zk_km1(:,it)    = zk_km1;
    Dk_k(:,it)      = dk_k; % distubrance estimate (physical units)
    Pk_k(:,it)      = pk_k;
    Sk_kmat(:,:,it) = Sk_k; % state error covariance
    Sk_ktrace(:,it) = trace(Sk_k);
    Sk_km1mat(:,:,it)=Sk_km1;
    Omks{it}  = Omk;
    Fkmat(:,:,it)   = Fk;   % state transition matrix
    Gkmat(:,:,it)   = Gk;   % input matrix
    Hkmat(:,:,it)   = Hk;   % output matrix
    Rkmat(:,:,it)   = Rk; 
    
    % next step
    Skm1_km1 = Sk_k;
    zkm1_km1 = zk_k;
    xdotkm1 = xdotk;    
    stapkm1 = stapk; 
    geopkm1 = geopk; 
    trapkm1 = trapk;
end

simres.X = Xk_k;
simres.G = G;
simres.V = V;
simres.Xdot = Xdotk;
simres.U = U;
simres.staps = staps;
simres.traps = traps;
simres.geops = geops;
simres.exitflags = exitflag;  
if model.equi.eq_call
	eqrecon = rap_liu_post_processing(params, subiter_info);
	simres.subiter_info = subiter_info;
	simres.eqrecon = eqrecon;
end

obsres.Xk_k = Xk_k; 
obsres.Xk_km1 = Xk_km1;
obsres.Zk_k = Zk_k;
obsres.Zk_km1 = Zk_km1;
obsres.Xdotk = Xdotk;
obsres.Pk_k = Pk_k;
obsres.Dk_k = Dk_k;
obsres.Sk_kmat = Sk_kmat;
obsres.Sk_ktrace = Sk_ktrace;
obsres.Sk_km1mat = Sk_km1mat;
obsres.Omks = Omks;
obsres.Hk_km1 = Hk_km1;
obsres.Hk_k = Hk_k;
obsres.M_k = H;
obsres.Rkmat = Rkmat;
obsres.Mk_act_channel = Mk_act_channel;
if KFparams.TS_diag_act
  obsres.RHO_tor_TS = RHO_tor_TS;
end
obsres.Fkmat = Fkmat;
obsres.Gkmat = Gkmat;
obsres.Hkmat = Hkmat;
obsres.res = res;
obsres.exitflag = exitflag;
obsres.ink = ink;
obsres.loglike_ink = loglike_ink;
obsres.Qk = Qk;
obsres.Lks = Lks;

return