function KF_plot_matrices(Fk,Hk,Sk_km1,Sk_k,Qk,Rk,Omk,Lk,Gk,KFmodel)

LH = Lk*Hk;

nz = KFmodel.nz;

hax = multiaxes(3,3,[],[],[]);
% plot covariance matrices

ax = hax(1);
imagesc(Hk*Sk_km1*Hk','parent',ax); title(ax,'H_kS_{k|k-1}H_k^T'); colorbar('peer',ax);

ax = hax(2);
imagesc(Rk,'parent',ax); title(ax,'R_k'); colorbar('peer',ax);

ax = hax(3);
imagesc(Omk,'parent',ax); title(ax,'\Omega_k'); colorbar('peer',ax);

ax = hax(4);
imagesc(Sk_km1,'parent',ax); title(ax,'S_{k|k-1}'); colorbar('peer',ax);

ax = hax(5);
imagesc(eye(nz) - LH(1:nz,1:nz),'parent',ax); title(ax,'I-L_kH_k'); colorbar('peer',ax);

ax = hax(6);
imagesc(Sk_k,'parent',ax); title(ax,'S_{k|k}'); colorbar('peer',ax);

ax = hax(7);
imagesc(Fk(1:nz,1:nz)*Sk_k(1:nz,1:nz)*Fk(1:nz,1:nz)','parent',ax); title(ax,'F_kS_{k|k}F_k^T'); colorbar('peer',ax);

ax = hax(8);
imagesc(Gk*Qk*Gk','parent',ax); title(ax,'G_kQ_kG_k^T'); colorbar('peer',ax);

ax = hax(9);
imagesc(Lk,'parent',ax); title(ax,'L_k'); colorbar('peer',ax);

set(hax(1:9),'xticklabel','','yticklabel','');

set(gcf,'position',[100 100 1000 700]);

return