function varargout = ntm(varargin) %#codegen

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Input processing
if nargin == 0,
    %% DEFAULT PARAMETERS
    varargout{1} = ntm('none');
    return %empty call, probably to get default structures
elseif nargin == 1
    % get default parameters for each case
    modeltype = varargin{1}; 
    switch modeltype
        case 'none'
            def_params = struct(...
                'method','direct'   , ... % method for solving NTM
                'n_ntm',0   , ... % number of NTMs
                'eqscal',1          , ... % scaling
                'modeltype','none'  , ... % default module
                'params', struct('active',false,'implicit',false)); % load default params
        case 'prescribed'
            def_params = ntm_prescribed;
        case 'mre'
            def_params = ntm_mre;
        otherwise
            error('invalid NTM model type ''%s''',modeltype)
    end
    varargout{1} = def_params; % return appropriate parameter structure
    return
else
    error('must call with 0 or 1 inputs');
end

%% % dummy (example) module
function varargout = ntm_prescribed(varargin)
if nargin == 0,
    Nntm=uint32(4);
    module_params = struct(...
        'active',true,...
        'implicit',false,...
        'm',[2; 3; 4; 3],...               % List of island poloidal mode numbers
        'n',[1; 2; 3; 1],...               % List of island toroidal mode numbers
        'chiefact_A',10*ones(Nntm,1), ...  % Increase of chie of 1+chiefact_A at rho_s
        'chiefact_w',2*ones(Nntm,1));      % Width factor of the chie increase (profile is Gaussian)
     def_params = struct(...
                'method','direct'       , ... % method for solving NTM
                'n_ntm',Nntm            , ... % number of NTMs
                'eqscal',1              , ...   % scaling
                'modeltype','prescribed', ... % default module
                'params', module_params); % load default params
    
    varargout{1} = def_params;
    return %empty call to get default structures
else
    error('must call with 0 inputs');
end
