function [xk1_post,icrash ] = RAPTOR_mhd(xk1,gk,vk,uk,it,RAPTORmodel,RAPTORparams)
% [xk1_post,icrash ] = saw_crash(xk1,gk,vk,uk,it,RAPTORmodel,RAPTORparams);
% Implements change of state due to sawtooth crash

xk1_post = xk1;
icrash = 0; % defaults

if RAPTORparams.saw.active
    icrash = saw_criteria(xk1, gk, vk, uk, it, RAPTORmodel, RAPTORparams.saw);
elseif ~isempty(RAPTORmodel.mhd.vind_saw)
    icrash = vk(RAPTORmodel.mhd.vind_saw); % sawtooth crash
end

if icrash
    % ensure large enough q=1 radius
    iota = eval_iota(xk1,gk,vk,RAPTORmodel,true);
    nq1 = sum(iota >= 1); % number of points with q<1
    if nq1 > 4; % reasonable number of points
        xk1_post = saw_full(xk1, gk, vk, uk, it, RAPTORmodel, RAPTORparams.saw);
    end
end

end

