function v = read_core_profiles_ids(model,params,core_profiles)

nions = numel(core_profiles.profiles_1d{1}.ion);

%% AVERAGED ION TEMPERATURE
if strcmp(model.ti.method, 'direct')
  ti = zeros(size(core_profiles.profiles_1d{1}.ion{1}.temperature));
  for iion = 1:nions
    ti = ti + abs(core_profiles.profiles_1d{1}.ion{iion}.temperature);
  end
  ti = ti/nions;
  profiles.ti  = ti;
end

profiles.ne  = abs(core_profiles.profiles_1d{1}.electrons.density);
% profiles.ni  = core_profiles.profiles_1d{1}.n_i_total_over_n_e.*core_profiles.profiles_1d{1}.electrons.density;
profiles.ni  = abs(core_profiles.profiles_1d{1}.n_i_thermal_total);
profiles.ze  = abs(core_profiles.profiles_1d{1}.zeff);
profiles.rho = core_profiles.profiles_1d{1}.grid.rho_tor_norm;

v = build_kinetic_profiles(model,params,profiles);

return

