function RAPTOR_inputs = map_IDS_to_RAPTOR_inputs(fs_summary, fs_cp, fs_cs, fs_eq, model, tgrid)

rhogauss = model.rgrid.rhogauss;
rho = model.rgrid.rho;

RAPTOR_inputs.time = tgrid;
RAPTOR_inputs.rhogauss = rhogauss;
RAPTOR_inputs.rho = rho;

%% summary
fields = ...
  { {'li'} 'li3'; ...
    {'h_98'}, 'H98y2'; ...
    {'beta_pol'}, 'betapol'; ...
    {'ip'}, 'Ip'; ...
    {'energy_thermal'}, 'Wth'; ...
    {'beta_tor'}, 'beta'; ...
    {'beta_tor_norm'}, 'betaN'}; % {'h_mode'}, 'H'; ...

it0 = find(fs_summary.time>fs_summary.time(1),1,'first')-1;
itf = find(fs_summary.time<fs_summary.time(end),1,'last')+1; 
for fieldind = 1:size(fields, 1)
  RAPTOR_inputs.(fields{fieldind,2}) = interp1(fs_summary.time(it0:itf), fs_summary.global_quantities.(fields{fieldind,1}{1}).value(it0:itf)', tgrid, 'linear', 'extrap');
end
if RAPTOR_inputs.Ip(1)<0
  IDSsgnIp=-1;
else
  IDSsgnIp=1;
end
RAPTOR_inputs.Ip = IDSsgnIp*RAPTOR_inputs.Ip;

%% core_profiles
fields = ...
  { {'electrons', 'temperature'} 'te' ; ...
    {'ion', 1, 'temperature'} 'ti' ; ...
    {'electrons', 'density'} 'ne'; ...
    {'electrons', 'density'} 'ne'; ...
    {'j_ohmic'} 'joh'; ... 
    {'j_total'} 'jpar'; ...
    {'grid', 'volume'} 'Volume'; ...
    {'grid', 'area'} 'Area'; ...
    {'zeff'}, 'ze'; ...
    {'q'}, 'q'; ...
    {'magnetic_shear'}, 'shear'; ...
    {'conductivity_parallel'}, 'signeo'};

it0 = find(fs_cp.time>fs_cp.time(1),1,'first')-1;
itf = find(fs_cp.time<fs_cp.time(end),1,'last')+1; 
for fieldind = 1:size(fields, 1)
  XX_rhog_t = zeros(numel(rhogauss), numel(fs_cp.time));
  XX_rho_t = zeros(numel(rho), numel(fs_cp.time));
  for tii = 1:numel(fs_cp.time)
    if numel(fields{fieldind,1})==1
      XX_rhog_t(:,tii) = interp1(fs_cp.profiles_1d{tii}.grid.rho_tor_norm, fs_cp.profiles_1d{tii}.(fields{fieldind,1}{1}), rhogauss, 'linear', 'extrap'); 
      XX_rho_t(:,tii) = interp1(fs_cp.profiles_1d{tii}.grid.rho_tor_norm, fs_cp.profiles_1d{tii}.(fields{fieldind,1}{1}), rho, 'linear', 'extrap'); 
    elseif numel(fields{fieldind,1})==2
      XX_rhog_t(:,tii) = interp1(fs_cp.profiles_1d{tii}.grid.rho_tor_norm, fs_cp.profiles_1d{tii}.(fields{fieldind,1}{1}).(fields{fieldind,1}{2}), rhogauss, 'linear', 'extrap'); 
      XX_rho_t(:,tii) = interp1(fs_cp.profiles_1d{tii}.grid.rho_tor_norm, fs_cp.profiles_1d{tii}.(fields{fieldind,1}{1}).(fields{fieldind,1}{2}), rho, 'linear', 'extrap'); 
    elseif numel(fields{fieldind,1})==3
      cellind = fields{fieldind,1}{2};
      XX_rhog_t(:,tii) = interp1(fs_cp.profiles_1d{tii}.grid.rho_tor_norm, fs_cp.profiles_1d{tii}.(fields{fieldind,1}{1}){cellind}.(fields{fieldind,1}{3}), rhogauss, 'linear', 'extrap'); 
      XX_rho_t(:,tii) = interp1(fs_cp.profiles_1d{tii}.grid.rho_tor_norm, fs_cp.profiles_1d{tii}.(fields{fieldind,1}{1}){cellind}.(fields{fieldind,1}{3}), rho, 'linear', 'extrap'); 
    end
  end
  RAPTOR_inputs.(strcat(fields{fieldind,2},'gauss')) = interp1(fs_cp.time(it0:itf), XX_rhog_t(:,it0:itf)', tgrid, 'linear', 'extrap')';
  RAPTOR_inputs.(fields{fieldind,2}) = interp1(fs_cp.time(it0:itf), XX_rho_t(:,it0:itf)', tgrid, 'linear', 'extrap')';
end
RAPTOR_inputs.joh = IDSsgnIp*RAPTOR_inputs.joh;
RAPTOR_inputs.johgauss = IDSsgnIp*RAPTOR_inputs.johgauss;
RAPTOR_inputs.jpar = IDSsgnIp*RAPTOR_inputs.jpar;
RAPTOR_inputs.jpargauss = IDSsgnIp*RAPTOR_inputs.jpargauss;

nions = numel(fs_cp.profiles_1d{1}.ion);
for ionind = 1:nions
  ionlabel = fs_cp.profiles_1d{1}.ion{ionind}.label; 
  NN_rhog_t = zeros(numel(rhogauss), numel(fs_cp.time));
  NN_rho_t = zeros(numel(rho), numel(fs_cp.time));
  for tii = 1:numel(fs_cp.time)
    NN_rhog_t(:,tii) = interp1(fs_cp.profiles_1d{tii}.grid.rho_tor_norm, fs_cp.profiles_1d{tii}.ion{ionind}.density, rhogauss, 'linear', 'extrap'); 
    NN_rho_t(:,tii) = interp1(fs_cp.profiles_1d{tii}.grid.rho_tor_norm, fs_cp.profiles_1d{tii}.ion{ionind}.density, rho, 'linear', 'extrap');   
  end
  RAPTOR_inputs.(strcat('n', ionlabel,'gauss')) = interp1(fs_cp.time(it0:itf), NN_rhog_t(:,it0:itf)', tgrid, 'linear', 'extrap')';
  RAPTOR_inputs.(strcat('n', ionlabel)) = interp1(fs_cp.time(it0:itf), NN_rho_t(:,it0:itf)', tgrid, 'linear', 'extrap')';
end

%% equilibrium

fields = ...
  { 'li_3' 'li3_equi' }; % {'h_mode'}, 'H'; ...

it0 = find(fs_eq.time>fs_eq.time(1),1,'first')-1;
itf = find(fs_eq.time<fs_eq.time(end),1,'last')+1; 
for fieldind = 1:size(fields, 1)
  XX_t = zeros(1, numel(fs_eq.time));
  for tii = 1:numel(fs_eq.time)
    XX_t(:,tii) = fs_eq.time_slice{tii}.global_quantities.(fields{fieldind,1}); 
  end
  RAPTOR_inputs.(fields{fieldind,2}) = interp1(fs_eq.time(it0:itf), XX_t(:,it0:itf)', tgrid, 'linear', 'extrap')';
end

fields = ...
  { 'q', 'q_equi'; ...
    'psi' 'psi_equi'};

it0 = find(fs_eq.time>fs_eq.time(1),1,'first')-1;
itf = find(fs_eq.time<fs_eq.time(end),1,'last')+1; 
for fieldind = 1:size(fields, 1)
  XX_rhog_t = zeros(numel(rhogauss), numel(fs_eq.time));
  XX_rho_t = zeros(numel(rho), numel(fs_eq.time));
  for tii = 1:numel(fs_eq.time)
    XX_rhog_t(:,tii) = interp1(fs_eq.time_slice{tii}.profiles_1d.rho_tor_norm, fs_eq.time_slice{tii}.profiles_1d.(fields{fieldind,1}), rhogauss, 'linear', 'extrap'); 
    XX_rho_t(:,tii) = interp1(fs_eq.time_slice{tii}.profiles_1d.rho_tor_norm, fs_eq.time_slice{tii}.profiles_1d.(fields{fieldind,1}), rho, 'linear', 'extrap'); 
  end
  RAPTOR_inputs.(strcat(fields{fieldind,2},'gauss')) = interp1(fs_eq.time(it0:itf), XX_rhog_t(:,it0:itf)', tgrid, 'linear', 'extrap')';
  RAPTOR_inputs.(fields{fieldind,2}) = interp1(fs_eq.time(it0:itf), XX_rho_t(:,it0:itf)', tgrid, 'linear', 'extrap')';
end
RAPTOR_inputs.psi_equigauss = IDSsgnIp*(RAPTOR_inputs.psi_equigauss-RAPTOR_inputs.psi_equi(end,1));
RAPTOR_inputs.psi_equi = IDSsgnIp*(RAPTOR_inputs.psi_equi-RAPTOR_inputs.psi_equi(end,1));


%% core sources
RAPTOR_inputs = append_IDSsrcprofs_toRAPTOR_inputs(RAPTOR_inputs, fs_cs, model, IDSsgnIp);
RAPTOR_inputs.Vpgauss = model.psi.Lampgauss * (model.psi.Lamgauss \ RAPTOR_inputs.Volumegauss);
RAPTOR_inputs.Areapgauss = model.psi.Lampgauss * (model.psi.Lamgauss \ RAPTOR_inputs.Areagauss);

RAPTOR_inputs.Pec = sum(bsxfun(@times,model.rgrid.wgauss.*RAPTOR_inputs.Vpgauss, RAPTOR_inputs.pecgauss));
RAPTOR_inputs.Pice = sum(bsxfun(@times,model.rgrid.wgauss.*RAPTOR_inputs.Vpgauss, RAPTOR_inputs.picegauss));
RAPTOR_inputs.Pici = sum(bsxfun(@times,model.rgrid.wgauss.*RAPTOR_inputs.Vpgauss, RAPTOR_inputs.picigauss));
RAPTOR_inputs.Pnbe = sum(bsxfun(@times,model.rgrid.wgauss.*RAPTOR_inputs.Vpgauss, RAPTOR_inputs.pnbegauss));
RAPTOR_inputs.Pnbi = sum(bsxfun(@times,model.rgrid.wgauss.*RAPTOR_inputs.Vpgauss, RAPTOR_inputs.pnbigauss));
RAPTOR_inputs.Plhe = sum(bsxfun(@times,model.rgrid.wgauss.*RAPTOR_inputs.Vpgauss, RAPTOR_inputs.plhegauss));
RAPTOR_inputs.Plhi = sum(bsxfun(@times,model.rgrid.wgauss.*RAPTOR_inputs.Vpgauss, RAPTOR_inputs.plhigauss));
RAPTOR_inputs.Palphae = sum(bsxfun(@times,model.rgrid.wgauss.*RAPTOR_inputs.Vpgauss, RAPTOR_inputs.palphaegauss));
RAPTOR_inputs.Palphai = sum(bsxfun(@times,model.rgrid.wgauss.*RAPTOR_inputs.Vpgauss, RAPTOR_inputs.palphaigauss));
RAPTOR_inputs.Pei = sum(bsxfun(@times,model.rgrid.wgauss.*RAPTOR_inputs.Vpgauss, RAPTOR_inputs.peigauss));
RAPTOR_inputs.Poh = sum(bsxfun(@times,model.rgrid.wgauss.*RAPTOR_inputs.Vpgauss, RAPTOR_inputs.pohgauss));
RAPTOR_inputs.Prad = sum(bsxfun(@times,model.rgrid.wgauss.*RAPTOR_inputs.Vpgauss, RAPTOR_inputs.pradgauss));
RAPTOR_inputs.Psync = sum(bsxfun(@times,model.rgrid.wgauss.*RAPTOR_inputs.Vpgauss, RAPTOR_inputs.psyncgauss));

RAPTOR_inputs.Iec = sum(bsxfun(@times,model.rgrid.wgauss.*RAPTOR_inputs.Areapgauss, RAPTOR_inputs.jecgauss));
RAPTOR_inputs.Inb = sum(bsxfun(@times,model.rgrid.wgauss.*RAPTOR_inputs.Areapgauss, RAPTOR_inputs.jnbgauss));
RAPTOR_inputs.Ilh = sum(bsxfun(@times,model.rgrid.wgauss.*RAPTOR_inputs.Areapgauss, RAPTOR_inputs.jlhgauss));
RAPTOR_inputs.Ibs = sum(bsxfun(@times,model.rgrid.wgauss.*RAPTOR_inputs.Areapgauss, RAPTOR_inputs.jbsgauss));
RAPTOR_inputs.Ioh = sum(bsxfun(@times,model.rgrid.wgauss.*RAPTOR_inputs.Areapgauss, RAPTOR_inputs.johgauss));

%% some derived profiles
RAPTOR_inputs.tep = model.te.Lamp * (model.te.Lam \ RAPTOR_inputs.te);
RAPTOR_inputs.tepgauss = model.te.Lampgauss * (model.te.Lamgauss \ RAPTOR_inputs.tegauss);

RAPTOR_inputs.lambdate = - bsxfun(@rdivide, RAPTOR_inputs.tep, RAPTOR_inputs.te);
RAPTOR_inputs.lambdategauss = - bsxfun(@rdivide, RAPTOR_inputs.tepgauss, RAPTOR_inputs.tegauss);



end