function U = get_HCD_waveform_from_IDS(pulse_schedule,params,U)

% ----> Read waveforms from input pulse_schedule IDS

% Search for active sources in pulse_schedule
for iantenna=1:numel(pulse_schedule.ec.antenna)
  if pulse_schedule.ec.antenna{iantenna}.power.reference.data > 0
    U(params.echcd.uindices(iantenna),:)=pulse_schedule.ec.antenna{iantenna}.power.reference.data;
  end
end
for iantenna=1:numel(pulse_schedule.ic.antenna)
  if pulse_schedule.ic.antenna{iantenna}.power.reference.data > 0
    U(params.ichcd.uindices(iantenna),:)=pulse_schedule.ic.antenna{iantenna}.power.reference.data;
  end
end
for iunit=1:numel(pulse_schedule.nbi.unit)
  if pulse_schedule.nbi.unit{iunit}.power.reference.data > 0
     U(params.nbhcd.uindices(iunit),:)=pulse_schedule.nbi.unit{iunit}.power.reference.data;
  end
end
for iantenna=1:numel(pulse_schedule.lh.antenna)
  if pulse_schedule.lh.antenna{iantenna}.power.reference.data > 0
    U(params.lhhcd.uindices(iantenna),:)=pulse_schedule.lh.antenna{iantenna}.power.reference.data;
  end
end

