function hcdsrc = get_HCD_manual_from_IDS(hcdsrc, hcdsrc_cs_index, core_sources, model, varargin)

if isempty(varargin)
  nrho = model.rgrid.nrhogauss;
  rhomodel = model.rgrid.rhogauss;
  timind = 1;
  IDSsgnIp = 1;
else
  gauss = varargin{1};
  if gauss
    nrho = model.rgrid.nrhogauss;
    rhomodel = model.rgrid.rhogauss;
  else
    nrho = model.rgrid.nrho;
    rhomodel = model.rgrid.rho;
  end
  timind = varargin{2};
  IDSsgnIp = varargin{3};
end

hcdsrc.Pauxe = zeros(nrho, 1);
hcdsrc.Pauxi = zeros(nrho, 1);
hcdsrc.jaux = zeros(nrho, 1);
for ii=1:numel(hcdsrc_cs_index)
  isource = hcdsrc_cs_index(ii);
  rho = core_sources.source{isource}.profiles_1d{timind}.grid.rho_tor_norm;
  pe = core_sources.source{isource}.profiles_1d{timind}.electrons.energy;
  nions = numel(core_sources.source{isource}.profiles_1d{timind}.ion);
  pi = zeros(size(core_sources.source{isource}.profiles_1d{timind}.electrons.energy));
  if ~isempty(core_sources.source{isource}.profiles_1d{timind}.ion{1}.energy)
    for iion = 1:nions
      pi = pi + core_sources.source{isource}.profiles_1d{timind}.ion{iion}.energy;
    end
  end
  j = IDSsgnIp*core_sources.source{isource}.profiles_1d{timind}.j_parallel; 

  if ~isempty(pe); hcdsrc.Pauxe = hcdsrc.Pauxe + interp1(rho, pe, rhomodel,'linear','extrap'); end
  if ~isempty(pi); hcdsrc.Pauxi = hcdsrc.Pauxi + interp1(rho, pi, rhomodel,'linear','extrap'); end
  if ~isempty(j); hcdsrc.jaux = hcdsrc.jaux + interp1(rho, j, rhomodel,'linear','extrap'); end
end

end