function [RAPTOR_inputs] = append_IDSsrcprofs_toRAPTOR_inputs(RAPTOR_inputs, fs_cs, model, IDSsgnIp)
% ----> Read H&CD profiles from input core_sources IDS

fields = {'pec','jec','pnbe','pnbi','jnb','pice','pici','jic','plhe','plhi','jlh','palphae','palphai','poh','jbs','prad','psync','pei'};
% joh

nsource = numel(fs_cs.source);
% nrho    = numel(core_sources.source{1}.profiles_1d{1}.grid.rho_tor_norm);
n_ec_antenna = 0;
n_ic_antenna = 0;
n_nb_antenna = 0;
n_lh_antenna = 0;
n_fusion = 0;
n_ohmic = 0;
n_bootstrap_current = 0;
n_radiation = 0;
n_synchrotron_radiation = 0;
n_collisional_equipartition = 0;

ec.active = 0;
ic.active = 0;
nb.active = 0;
lh.active = 0;
fus.active = 0;
ohm.active = 0;
bs.active = 0;
rad.active = 0;
radsync.active = 0;
pei.active = 0;

ec_cs_idx = [];
ic_cs_idx = [];
nb_cs_idx = [];
lh_cs_idx = [];
fs_cs_idx = [];
oh_cs_idx = [];
bs_cs_idx = [];
rd_cs_idx = [];
rs_cs_idx = [];
eq_cs_idx = [];
  
for isource=1:nsource
  if strcmp(fs_cs.source{isource}.identifier.name,'ec')
    n_ec_antenna = n_ec_antenna + 1;
    ec.active = 1;
    ec_cs_idx = [ec_cs_idx isource]; % Indices in core_sources IDS
  end
  if strcmp(fs_cs.source{isource}.identifier.name,'ic')
    n_ic_antenna = n_ic_antenna + 1;
    ic.active = 1;
    ic_cs_idx = [ic_cs_idx isource]; % Indices in core_sources IDS
  end
  if strcmp(fs_cs.source{isource}.identifier.name,'nbi')
    n_nb_antenna = n_nb_antenna + 1;
    nb.active = 1;
    nb_cs_idx = [nb_cs_idx isource]; % Indices in core_sources IDS
  end
  if strcmp(fs_cs.source{isource}.identifier.name,'lh')
    n_lh_antenna = n_lh_antenna + 1;
    lh.active = 1;
    lh_cs_idx = [lh_cs_idx isource]; % Indices in core_sources IDS
  end
  if strcmp(fs_cs.source{isource}.identifier.name,'fusion')
    n_fusion = n_fusion + 1;
    fus.active = 1;
    fs_cs_idx = [fs_cs_idx isource]; % Indices in core_sources IDS
  end
  if strcmp(fs_cs.source{isource}.identifier.name,'ohmic')
    n_ohmic = n_ohmic + 1;
    ohm.active = 1;
    oh_cs_idx = [oh_cs_idx isource]; % Indices in core_sources IDS
  end
  if strcmp(fs_cs.source{isource}.identifier.name,'bootstrap_current')
    n_bootstrap_current = n_bootstrap_current + 1;
    bs.active = 1;
    bs_cs_idx = [bs_cs_idx isource]; % Indices in core_sources IDS
  end
  if strcmp(fs_cs.source{isource}.identifier.name,'radiation')
    n_radiation = n_radiation + 1;
    rad.active = 1;
    rd_cs_idx = [rd_cs_idx isource]; % Indices in core_sources IDS
  end
  if strcmp(fs_cs.source{isource}.identifier.name,'synchrotron_radiation')
    n_synchrotron_radiation = n_synchrotron_radiation + 1;
    radsync.active = 1;
    rs_cs_idx = [rs_cs_idx isource]; % Indices in core_sources IDS
  end
  if strcmp(fs_cs.source{isource}.identifier.name,'collisional_equipartition')
    n_collisional_equipartition = n_collisional_equipartition + 1;
    pei.active = 1;
    eq_cs_idx = [eq_cs_idx isource]; % Indices in core_sources IDS
  end 
end

for fieldind = 1:numel(fields)
  srcprofs.(strcat(fields{fieldind},'gauss')) = zeros(model.rgrid.nrhogauss, numel(fs_cs.time));
  srcprofs.(fields{fieldind})                 = zeros(model.rgrid.nrho, numel(fs_cs.time));
end

for tii = 1:numel(fs_cs.time)
  ecgauss = get_HCD_manual_from_IDS(ec, ec_cs_idx, fs_cs, model, true, tii, IDSsgnIp);
  ec = get_HCD_manual_from_IDS(ec, ec_cs_idx, fs_cs, model, false, tii, IDSsgnIp);
  icgauss = get_HCD_manual_from_IDS(ic, ic_cs_idx, fs_cs, model, true, tii, IDSsgnIp);
  ic = get_HCD_manual_from_IDS(ic, ic_cs_idx, fs_cs, model, false, tii, IDSsgnIp);
  nbgauss = get_HCD_manual_from_IDS(nb, nb_cs_idx, fs_cs, model, true, tii, IDSsgnIp);
  nb = get_HCD_manual_from_IDS(nb, nb_cs_idx, fs_cs, model, false, tii, IDSsgnIp);
  lhgauss = get_HCD_manual_from_IDS(lh, lh_cs_idx, fs_cs, model, true, tii, IDSsgnIp);
  lh = get_HCD_manual_from_IDS(lh, lh_cs_idx, fs_cs, model, false, tii, IDSsgnIp);
  fusgauss = get_HCD_manual_from_IDS(fus, fs_cs_idx, fs_cs, model, true, tii, IDSsgnIp);
  fus = get_HCD_manual_from_IDS(fus, fs_cs_idx, fs_cs, model, false, tii, IDSsgnIp);
  ohmgauss = get_HCD_manual_from_IDS(ohm, oh_cs_idx, fs_cs, model, true, tii, IDSsgnIp);
  ohm = get_HCD_manual_from_IDS(ohm, oh_cs_idx, fs_cs, model, false, tii, IDSsgnIp);
  bsgauss = get_HCD_manual_from_IDS(bs, bs_cs_idx, fs_cs, model, true, tii, IDSsgnIp);
  bs = get_HCD_manual_from_IDS(bs, bs_cs_idx, fs_cs, model, false, tii, IDSsgnIp);
  radgauss = get_HCD_manual_from_IDS(rad, rd_cs_idx, fs_cs, model, true, tii, IDSsgnIp);
  rad = get_HCD_manual_from_IDS(rad, rd_cs_idx, fs_cs, model, false, tii, IDSsgnIp);
  radsyncgauss = get_HCD_manual_from_IDS(radsync, rs_cs_idx, fs_cs, model, true, tii, IDSsgnIp);
  radsync = get_HCD_manual_from_IDS(radsync, rs_cs_idx, fs_cs, model, false, tii, IDSsgnIp);
  peigauss = get_HCD_manual_from_IDS(pei, eq_cs_idx, fs_cs, model, true, tii, IDSsgnIp);
  pei = get_HCD_manual_from_IDS(pei, eq_cs_idx, fs_cs, model, false, tii, IDSsgnIp);

  srcprofs.pecgauss(:,tii) = ecgauss.Pauxe; srcprofs.pec(:,tii) = ec.Pauxe;
  srcprofs.jecgauss(:,tii) = ecgauss.jaux; srcprofs.jec(:,tii) = ec.jaux;
  srcprofs.pnbegauss(:,tii) = nbgauss.Pauxe; srcprofs.pnbe(:,tii) = nb.Pauxe;
  srcprofs.pnbigauss(:,tii) = nbgauss.Pauxi; srcprofs.pnbi(:,tii) = nb.Pauxi;
  srcprofs.jnbgauss(:,tii) = nbgauss.jaux; srcprofs.jnb(:,tii) = nb.jaux;
  srcprofs.picegauss(:,tii) = icgauss.Pauxe; srcprofs.pice(:,tii) = ic.Pauxe;
  srcprofs.picigauss(:,tii) = icgauss.Pauxi; srcprofs.pici(:,tii) = ic.Pauxi;
  srcprofs.jicgauss(:,tii) = icgauss.jaux; srcprofs.jic(:,tii) = ic.jaux;
  srcprofs.plhegauss(:,tii) = lhgauss.Pauxe; srcprofs.plhe(:,tii) = lh.Pauxe;
  srcprofs.plhigauss(:,tii) = lhgauss.Pauxi; srcprofs.plhi(:,tii) = lh.Pauxi;
  srcprofs.jlhgauss(:,tii) = lhgauss.jaux; srcprofs.jlh(:,tii) = lh.jaux;
  srcprofs.palphaegauss(:,tii) = fusgauss.Pauxe; srcprofs.palphae(:,tii) = fus.Pauxe;
  srcprofs.palphaigauss(:,tii) = fusgauss.Pauxi; srcprofs.palphai(:,tii) = fus.Pauxi;
  srcprofs.pohgauss(:,tii) = ohmgauss.Pauxe; srcprofs.poh(:,tii) = ohm.Pauxe;
  % srcprofs.johgauss(:,tii) = ohmgauss.jaux; srcprofs.joh(:,tii) = ohm.jaux;
  srcprofs.jbsgauss(:,tii) = bsgauss.jaux; srcprofs.jbs(:,tii) = bs.jaux;
  srcprofs.pradgauss(:,tii) = radgauss.Pauxe; srcprofs.prad(:,tii) = rad.Pauxe;
  srcprofs.psyncgauss(:,tii) = radsyncgauss.Pauxe; srcprofs.psync(:,tii) = radsync.Pauxe;
  srcprofs.peigauss(:,tii) = peigauss.Pauxe; srcprofs.pei(:,tii) = pei.Pauxe;
end

it0 = find(fs_cs.time>fs_cs.time(1),1,'first')-1;
itf = find(fs_cs.time<fs_cs.time(end),1,'last')+1; 
for fieldind = 1:numel(fields)
  RAPTOR_inputs.(strcat(fields{fieldind},'gauss')) = interp1(fs_cs.time(it0:itf), srcprofs.(strcat(fields{fieldind},'gauss'))(:,it0:itf)', RAPTOR_inputs.time, 'linear', 'extrap')';
  RAPTOR_inputs.(fields{fieldind})                 = interp1(fs_cs.time(it0:itf), srcprofs.(fields{fieldind})(:,it0:itf)', RAPTOR_inputs.time, 'linear', 'extrap')';
end

return