function init = prepare_init(config)


%% init
switch config.te.method
  case 'state'
    init.te0 = config.init.te0;
    init.tewidth = config.init.tewidth;
  otherwise
    error('unsupported')
end

switch config.ti.method
  case {'direct','state'}
    init.ti0     = config.init.ti0;
    init.tiwidth = config.init.tiwidth;
  case 'tescal'
    init.ti0scal = config.init.ti0/config.init.te0;
    init.tiescal = config.init.ti0/config.init.te0;
  otherwise
    error('unsupported')
end

switch config.ne.method
  case {'direct','state'}
    init.ne0 = config.init.ne0;
    init.newidth = config.init.newidth;
  case {'qnze'}
    % do nothing
  otherwise
    error('unsupported')
end

switch config.ni.method
  case {'direct','state'}
    init.ni0 = config.init.ni0;
    init.niwidth = config.init.niwidth;
  case 'nescal'
    init.ni0scal = config.init.ni0/config.init.ne0;
    init.niescal = init.ni0scal;
  case 'qnze'
    % do nothing
  otherwise
    error('unsupported')
end

for ii=1:3
  met=config.(sprintf('n%i',ii)).method;
  switch met
    case 'direct'
      % nothing
    case {'nescal','niscal'}
      init.(sprintf('n%iscal',ii)) = config.init.(sprintf('n%iscal',ii));
    case 'qnze'
      % do nothing
    otherwise
      error('unsupported')
  end
end

switch config.ze.method
  case 'direct'
    init.ze0 = config.init.ze0;
    init.zee = config.init.zee;
  case 'qnze'
    % do nothing
  otherwise
    error('unsupported')
end

switch config.vt.method
  case 'direct'
    init.vt0 = config.init.vt0;
    init.vte = config.init.vte;
  otherwise
    error('unsupported')
end

init.jpow = config.init.jpow;
init.Ip0  = config.init.Ip0;
init.psib0 = config.init.psib0;
return