function input_checks(x0,Gin,Vin,Uin,model,params)


%% check nans in inputs
assert(~any(isnan(x0)),'NaNs in x0');
assert(~any(any(isnan(Gin))),'NaNs in g0');
assert(~any(any(isnan(Vin))),'NaNs in v0');
assert(~any(any(isnan(Uin))),'NaNs in U_ff');

%% Sizes
nt = numel(params.tgrid);
assert(size(Uin,2) == nt,'size(2) of U_ff must match size of v')
%%
% various checks
if params.numerics.usemex
    assert(model.buildopts.mexify,'numerics.usemex is not allowed unless model is generated with buildopts.mexify=true')
    assert(~~exist('RAPTOR_predictive_step_mex','file'),'RAPTOR_predictive_step_mex does not exist')
end

if isfield(params.numerics,'realtime')
  error('this use is deprecated, set config.realtime instead, which sets model.realtime')
end

assert(isrow(params.tgrid),'params.tgrid must be a row vector');

%% check for obsolete things
if isfield(params,'sigma_neo')
    error('''sigma_neo'' has been replaced by ''neos''. use params.neos instead of params.sigma_neo')
end
if isfield(params,'bs')
    error('''bs'' has been replaced by ''neos''. use params.neos instead of params.sigma_neo')
end

assert(model.np==0,'not supported any more')

assert(~isfield(model,'tnz'),'tnz field no longer in use for RAPTOR, please remove');

%%
% check input indices for conflicts
if ~strcmp(model.echcd.name,'none'), uec = model.echcd.uind; 
else uec = []; end

if ~strcmp(model.nbhcd.name,'none'), unb = model.nbhcd.uind;
else unb = []; end

if ~strcmp(model.lhhcd.name,'none'), ulh = model.lhhcd.uind;
else ulh = []; end

if ~strcmp(model.ichcd.name,'none'), uic = model.ichcd.uind;
else uic = []; end

uu = [1 uec unb ulh uic];

assert(numel(uu)==model.dims.nu,'input indices do not match amount model.dims.nu')
assert(all(sort(uu)==1:numel(uu)),'uindices are not contiguous. Check input module params.uindices for conflicts')

% check NTM explicit settings
if strcmp(model.ntm.method,'state') && params.ntm.active
    assert(~params.ntm.implicit,'NTM in implicit mode not supported yet')
    assert((~params.neos.implicit),'must set params.neos.implicit to false to run NTM module')
end

end