function [echcd,nbhcd,ichcd] = default_params_AUG(params)

echcd = params.echcd;
echcd.active = true;
echcd.rdep = [0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0]; %use rhodep, not rdep
echcd.wdep = [0.3 0.3 0.3 0.3 0.3 0.3 0.3 0.3];
echcd.h_eff = [1  1   1   1   1   1   1   1  ];
echcd.cd_eff =[0  0   0   0   0   0   0   0  ];

nbhcd = params.nbhcd;
nbhcd.active = true;
nbhcd.rdep     = [0.05  0.1  0.05  0.05 0.17 0.43 0.37 0.08];
nbhcd.wdep     = 2*[0.2 0.3  0.3   0.3  0.3  0.18  0.20 0.25]; % 2*half width
nbhcd.wdep_out = 2*[0.4 0.35 0.35   0.35  0.35  0.29 0.30 0.35];
nbhcd.cd_eff =   [0.5119    0.8123    0.8670    0.5539    0.8647    1.3500    1.5853    0.9539];
nbhcd.eta_jcd0 = 1/5; % to get about 100kA per 5MW beam power
nbhcd.frac_to_electrons  = [1.6926    1.6760    1.6396    1.6527    1.9848    2.4017    2.4039    1.9844]/5; % MW to electrons per MW input power

ichcd = params.ichcd;
ichcd.active = true;
ichcd.rdep = [0.0 0.0];
ichcd.wdep = [0.4 0.4];
ichcd.cd_eff = [0  0];

end