function RAPTOR_mexify(model,params)
% mexify RAPTOR_predictive_step for current model settings

% run test function to initialize variables

% function to mexify:
%  RAPTOR_predictive_step(it,dt,xk,xdotk,gk,gdot,vk,vdot,u,xdk,model,params)

%% define examples
x0 = ones(model.dims.nx,1);
g0 = zeros(model.dims.ng,1);
v0 = ones(model.dims.nv,1);
u0 = ones(model.dims.nu,1);
d0 = zeros(model.dims.nd,1);

it = coder.typeof(1);
dt = coder.typeof(1);
xk = coder.typeof(x0);
gk = coder.typeof(g0);
vk = coder.typeof(v0);
u  = coder.typeof(u0);
xdk = coder.Constant(zeros(model.dims.nd,1));
modeltype  = coder.Constant(model); % code is generated for constant model
paramstype = coder.typeof(params);

%% check if correct mex already exists
if ~~exist('RAPTOR_predictive_step_mex','file')
   % try to run it with the present model
   try
       disp('RAPTOR_predictive_step_mex already seems to exist for this model')
       fprintf('Delete %s to force generation of new mex\n',which('RAPTOR_predictive_step_mex'))
       return % exit here
   catch me
       % continue
   end
end

%% settings
codercfg = coder.config('mex');
example_inputs = {it,dt,xk,xk,gk,gk,vk,vk,u,xdk,modeltype,paramstype};
code_folder = get_param(0,'CodeGenFolder');
out_file = fullfile(model.envopts.RAPTOR_path,'code','solver','RAPTOR_predictive_step_mex');
entry_point_fct = which('RAPTOR_predictive_step');

%% run codegen
fprintf('Generating mex for RAPTOR_predictive_step, please wait...')
codegencmd = sprintf('codegen -d %s -o %s -config codercfg %s -args example_inputs',code_folder,out_file,entry_point_fct);
eval(codegencmd)
fprintf('..done\n')

end